package cn.com.duiba.tuia.ssp.center.api.dto.monthreport;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 入口数据
 *
 * @author fangzhipeng
 * @date 2018/9/20
 */
public class EntranceData implements Serializable, GetSetDate {


    private static final long serialVersionUID = -1061273223861419617L;

    /**
     * 对应日期 yyyy-MM-dd 格式
     */
    private String date;

    /**
     * 曝光量
     */
    private Long exposureCount  = 0L;


    /**
     * 点击量
     */
    private Long clickCount = 0L;

    /**
     * 点击率
     */
    private Float clickRate = 0F;

    public EntranceData() {}

    public EntranceData(String date, Long exposureCount, Long clickCount) {
        this.date = date;
        this.exposureCount = exposureCount;
        this.clickCount = clickCount;
        this.clickRate = calculateClickRate(this.clickCount, this.exposureCount);
    }

    public EntranceData merge(EntranceData other) {
        this.exposureCount = this.exposureCount + other.getExposureCount();
        this.clickCount = this.clickCount + other.getClickCount();
        this.clickRate = calculateClickRate(this.clickCount, this.exposureCount);
        return this;
    }

    @Override
    public String getDate() {
        return date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    public Long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getClickCount() {
        return clickCount;
    }

    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    public Float getClickRate() {
        return clickRate;
    }

    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * calculateClickRate:(计算点击率). <br/>
     *
     * @param divisor  分子
     * @param dividend 分母
     * @return the float
     * @author ZFZ
     * @since JDK 1.6
     */
    public static Float calculateClickRate(Long divisor, Long dividend) {
        Float result = null;
        if (dividend != null && divisor != null && divisor.longValue() != 0 && dividend.longValue() != 0) {
            BigDecimal bigDivisor = new BigDecimal(divisor * 100);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 2, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return result;
    }


}
