package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseCashBillDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordDto;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordErrorDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordOrderDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord.PrePayInvoiceRecordReq;

import java.util.List;

/**
 * 预付款发票纪录
 */
@AdvancedFeignClient
public interface RemotePrePayInvoiceRecordService {
    /**
     * 预付款发票纪录
     *
     * @param param
     * @return
     */
    PageResultDto<PrePayInvoiceRecordDto> pagePrePayInvoiceRecord(PrePayInvoiceRecordReq param);

    /**
     * 保存
     *
     * @param param
     */
    Boolean savePrePayInvoiceRecord(PrePayInvoiceRecordDto param);

    /**
     * 修改
     *
     * @param param
     */
    Boolean updatePrePayInvoiceRecord(PrePayInvoiceRecordDto param);

    /**
     * 删除预付款发票
     * id:发票ID
     */
    Boolean deletePrePayInvoiceRecordById(Long id);

    /**
     * 查询预付款发票
     */
    List<PrePayInvoiceRecordDto> listPrePayInvoiceRecord(PrePayInvoiceRecordReq param);

    /**
     * 通过媒体用户IDS
     *
     * @return
     */
    List<PrePayInvoiceRecordDto> listPrePayInvoiceRecordByParam(PrePayInvoiceRecordReq param);


    List<PrePayInvoiceRecordDto> listAndGroupByMediaIds(List<Long> mediaIds);

    /**
     * 根据预付款单号查询已开票金额
     * @param prePayOrderIds 预付款单号列表
     * @return 已开票金额
     */
    List<PrePayInvoiceRecordOrderDTO> listAndGroupByPrePayOrderIds(List<Long> prePayOrderIds);

    /**
     * 查询指定日期之前的已开票金额
     */
    List<PrePayInvoiceRecordOrderDTO> listPrePayInvoiceBeforeDate(PrePayInvoiceRecordReq param);

    /**
     * 查询已开票金额等
     */
    List<PrePayInvoiceRecordDto> listAndGroupByParam(PrePayInvoiceRecordReq param);

    /**
     * 校验发票
     */
    List<PrePayInvoiceRecordErrorDTO> verifyInvoices(List<BaseCashBillDto> invoices);

    /**
     * 提交发票
     */
    Boolean saveInvoices(List<BaseCashBillDto> invoices);

    /**
     * 查询发票明细
     */
    BaseCashBillDto getInvoice(PrePayInvoiceRecordReq param);

    /**
     * 查询发票明细列表
     */
    List<BaseCashBillDto> listInvoiceDetail(PrePayInvoiceRecordReq param);

    /**
     * 更新发票明细
     */
    Boolean updateInvoice(BaseCashBillDto invoice);
}
