package cn.com.duiba.tuia.ssp.center.api.constant;

import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public enum AgentSettlementTypeEnum {

    HZ_AGENT((byte)0, "杭推代理结算单"),
    HEGS_AGENT((byte)1, "霍推代理结算单"),
    HCDJ_AGENT((byte)2, "兑捷代理结算单"),


    HZ_TO_HEGS_AGENT((byte)3, "杭推纳入霍推代理结算单"),
    HZ_HEGS_TO_HCDJ_AGENT((byte)4, "杭推和霍推纳入兑捷代理结算单"),
    HZ_HCDJ_TO_HEGS_AGENT((byte)5, "杭推和兑捷纳入霍推代理结算单"),
    HZ_TO_HCDJ_AGENT((byte)6, "杭推纳入兑捷代理结算单"),
    HEGS_TO_HZ_AGENT((byte)7, "霍推纳入杭推代理结算单"),
    HCDJ_TO_HZ_AGENT((byte)8, "兑捷纳入杭推代理结算单"),

    /**
     * 杭推理论收入差值为负，这部分收入实际应分配给其他主体，即杭推实际结算的钱里有一部分应该属于其他主体的，杭推需应付给其他主体的钱
     * @see <a href="http://cf.dui88.com/pages/viewpage.action?pageId=161420941"/>
     */
    HZ_OVERALLOC_AGENT((byte) 9, "杭推代理结算单(超配)"),
    /**
     * 霍推理论收入差值为负，这部分收入实际应分配给其他主体，即霍推实际结算的钱里有一部分应该属于其他主体的，霍推需应付给其他主体的钱
     * @see <a href="http://cf.dui88.com/pages/viewpage.action?pageId=161420941"/>
     */
    HEGS_OVERALLOC_AGENT((byte) 10, "霍推代理结算单(超配)"),
    /**
     * 兑捷理论收入差值为负，这部分收入实际应分配给其他主体，即兑捷实际结算的钱里有一部分应该属于其他主体的，兑捷需应付给其他主体的钱
     * @see <a href="http://cf.dui88.com/pages/viewpage.action?pageId=161420941"/>
     */
    HCDJ_OVERALLOC_AGENT((byte) 11, "兑捷代理结算单(超配)")


    ;

    private Byte type;
    private String desc;

    AgentSettlementTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static final Map<Byte, String> AGENT_COMPANY_MAP;

    public static final Map<Byte, AgentSettlementTypeEnum> AGENT_COMPANYENUM_MAP;
    //霍推的状态list
    public static final List<Byte> hegsList = Lists.newArrayList(HEGS_AGENT.type,HZ_TO_HEGS_AGENT.type,
            HZ_HCDJ_TO_HEGS_AGENT.type, HEGS_OVERALLOC_AGENT.type);
    //兑捷的状态list
    public static final List<Byte> hcdjList = Lists.newArrayList(HCDJ_AGENT.type,
            HZ_HEGS_TO_HCDJ_AGENT.type, HZ_TO_HCDJ_AGENT.type, HCDJ_OVERALLOC_AGENT.type);

    static {
        Map<Byte, String> temp = new HashMap<>(AgentSettlementTypeEnum.values().length, 1);
        for (AgentSettlementTypeEnum tag: AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), tag.getDesc());
        }
        AGENT_COMPANY_MAP = Collections.unmodifiableMap(temp);
    }

    static {
        Map<Byte, AgentSettlementTypeEnum> temp = new HashMap<>(AgentSettlementTypeEnum.values().length, 1);
        for (AgentSettlementTypeEnum tag: AgentSettlementTypeEnum.values()) {
            temp.put(tag.getType(), tag);
        }
        AGENT_COMPANYENUM_MAP = Collections.unmodifiableMap(temp);
    }

    public Byte getType() {
        return type;
    }

    public void setType(final Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(final String desc) {
        this.desc = desc;
    }

    public static String getCompanyName(Integer type) {
        for(AgentSettlementTypeEnum settlementType : AgentSettlementTypeEnum.values()) {
            if(settlementType.getType().equals(type)) {
                return settlementType.getDesc();
            }
        }
        return null;
    }

    /**
     * 把新加的状态 type  转换成 0-杭推 1 霍推 2兑捷  返回出去
     * @param type
     * @return
     */
    public static Byte getSettlementType(final Byte type) {
        if(hegsList.contains(type)){
            return HEGS_AGENT.type;
        }
        if(hcdjList.contains(type)){
            return HCDJ_AGENT.type;
        }
        return HZ_AGENT.type;
    }
}