package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 媒体账户金额调整表
 */
@Data
public class AccountChangeAdjustAuditDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    protected Long            id;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    protected Date            gmtCreate;

    /**
     * 最新更新时间
     */
    protected Date            gmtModified;
    /**
     * 账号id
     */
    private Long mediaId;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 审核状态 0-待审核 1-审核通过 2-审核拒绝'
     */
    private Integer auditStatus;
    /**
     * 创建人id
     */
    private Long createId;
    /**
     * 创建人姓名
     */
    private String createName;
    /**
     * 需调整账户余额
     */
    private Long balance;
    /**
     * 总调整金额
     */
    private Long amount;
    /**
     * 杭州账户余额
     */
    private Long hzBalance;
    /**
     * 杭州调整金额
     */
    private Long hzAmount;
    /**
     * 霍尔果斯账户余额
     */
    private Long hegsBalance;
    /**
     * 霍尔果斯调整金额
     */
    private Long hegsAmount;
    /**
     * 霍城兑捷账户余额
     */
    private Long hcdjBalance;
    /**
     * 霍城兑捷调整金额
     */
    private Long hcdjAmount;
    /**
     * 原账户余额
     */
    private Long originalBalance;
    /**
     * 原杭州账户余额
     */
    private Long originalHzBalance;
    /**
     * 原霍尔果斯账户余额
     */
    private Long originalHegsBalance;
    /**
     * 原霍城兑捷账户余额
     */
    private Long originalHcdjBalance;
    /**
     * 审核人id
     */
    private Long auditId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

    private Integer currentPage;

    private Integer pageSize;

    private Integer rowStart;


}
