package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuantong
 * 钉钉通知的bizType
 */
public enum BizTypeEnum {

    ALGO_MANUAL_BIZ((byte) 0, "算法人工切量业务");

    public static final Map<String, Byte> ALGO_MANUAL_MAP;

    static {
        Map<String, Byte> temp = new HashMap<>(BizTypeEnum.values().length, 1);
        for (BizTypeEnum tag: BizTypeEnum.values()) {
            temp.put(tag.name(), tag.getCode());
        }
        ALGO_MANUAL_MAP = Collections.unmodifiableMap(temp);
    }

    BizTypeEnum(final Byte code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Byte getByteType(String value) {
        return ALGO_MANUAL_MAP.get(value);
    }


    private Byte code;
    private String desc;

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
