package cn.com.duiba.tuia.ssp.center.api.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuefeng on 2018/3/20.
 */
public enum TuiaCompanyType {
    HANG_ZHOU(0, "杭州推啊网络科技有限公司"),
    HUO_ER_GUO_SI(1, "霍尔果斯推啊网络科技有限公司"),
    HCDJ(2, "霍城兑捷网络科技有限公司"),
    DUI_TUI(3, "霍尔果斯兑推网络有限公司")
    ;

    private Integer type;
    private String companyName;

    TuiaCompanyType(Integer type, String companyName) {
        this.type = type;
        this.companyName = companyName;
    }

    public static final Map<Integer, TuiaCompanyType> TUIA_COMPANY_MAP;

    public static final Map<Integer, Integer> TUIA_COMPANY_INIT_MAP;

    static {
        Map<Integer, TuiaCompanyType> temp = new HashMap<>(TuiaCompanyType.values().length, 1);
        for (TuiaCompanyType tag: TuiaCompanyType.values()) {
            temp.put(tag.getType(), tag);
        }
        TUIA_COMPANY_MAP = Collections.unmodifiableMap(temp);
    }

    static {
        Map<Integer, Integer> initTemp = new HashMap<>(TuiaCompanyType.values().length, 1);
        for (TuiaCompanyType tag: TuiaCompanyType.values()) {
            initTemp.put(tag.getType(), 0);
        }
        TUIA_COMPANY_INIT_MAP = Collections.unmodifiableMap(initTemp);
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public static String getCompanyName(Integer type) {
        for(TuiaCompanyType tuiaCompanyType : TuiaCompanyType.values()) {
            if(tuiaCompanyType.getType().equals(type)) {
                return tuiaCompanyType.getCompanyName();
            }
        }
        return null;
    }

    public static Integer getCompanyType(String companyName) {
        for(TuiaCompanyType tuiaCompanyType : TuiaCompanyType.values()) {
            if(StringUtils.equals(tuiaCompanyType.getCompanyName(), companyName)) {
                return tuiaCompanyType.getType();
            }
        }
        return null;
    }
}