package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountAdjustDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountMonthReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountMonthReportByPage;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountAdjustService {

    List<AccountAdjustDTO> getListByParam(AccountAdjustDTO req);

    void save(AccountAdjustDTO dto);

    void updateById(AccountAdjustDTO dto);

    /**
     * @Description  调账记录审核逻辑
     * @Date 15:20 2020-09-18
     * @Param [dto]
     * @return void
     **/
    void auditById(AccountAdjustDTO dto);

    void removeByIds(List<Long> ids);

    PageResultDto<AccountAdjustDTO> selectListByPage(ReqAccountMonthReportByPage req);

    AccountAdjustDTO getById(Long id);

    /**
     * 获取调账记录
     * @param appIds appId  列表
     * @param curDates 当前时间列表
     * @param mediaId 媒体Id
     * @return
     */
    List<AccountAdjustDTO> getAdjustAmountReasonListForNearly(List<Long> appIds,List<String> curDates,Long mediaId);

    /**
     * 通过appId、curDate、mediaId查询 月调账金额
     * @param appIds
     * @param curDates
     * @param mediaId
     * @return
     */
    List<AccountAdjustDTO> selectMonthAdjustAmountByAppIdAndCurDateAndMediaId(List<Long> appIds, List<String> curDates, Long mediaId);
}
