package cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 创意 ( 广告 ) Request
 * @dateTime 2019-10-09 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class ListingRequest implements Serializable {

    /*
     * 广告 Id
     * 是否必填 : 否
     */
    private Long advertId;

    /*
     * 审核状态
     * 注: { 0 : 初始化 , 1 : 待审核 , 2 : 审核通过 , 3 : 审核拒接 , 4 : 系统下线 }
     * 是否必填 : 否
     */
    private Integer status;

    /*
     * 投放开关
     * 注: { 0 : 关闭 , 1 : 开启 }
     */
    private Integer materialSwitch;

    /*
     * 分页页数
     * 是否必填 : 是
     */
    private Integer currentPage;

    /*
     * 分页条数
     * 是否必填 : 是
     */
    private Integer pageSize;


    /*
     * 广告 Ids
     * 是否必填 : 否
     */
    private List<Long> advertIds;

    /*
     * 创意ids
     * 是否必填 : 否
     */
    private List<Long> mediaAdvertIds;


    /*
     * 广告 Idstr
     * 是否必填 : 否
     */
    private String advertIdStr;

    /*
     * 创意idstr
     * 是否必填 : 否 string 类型
     */
    private String mediaAdvertIdStr;

    /**
     * 开始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    private Long appId;
}
