package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

@Getter
@AllArgsConstructor
public enum ExternalPlatformMediaAccountEnum {

    IQIYI(0, "爱奇艺"),
    KUAI_SHOU(1, "快手"),
    THREE_SIX_ZERO(2,"360"),
    OPPO(3,"oppo"),
    BAIDU(4,"百度"),
    MANGO(5,"芒果"),
    WEIBO(6,"微博"),
    GUAN_DIAN_TONG(7,"广点通"),
    VIVO(8,"vivo"),
    OCEN(9, "巨量"),
    XIAOMI(10,"小米"),
    ;

    private Integer type;

    private String name;

    public static String getNameByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ExternalPlatformMediaAccountEnum accountEnum : ExternalPlatformMediaAccountEnum.values()) {
            if (accountEnum.type.equals(type)) {
                return accountEnum.name;
            }
        }
        return null;
    }

    public static Integer getTypeByName(String name){
        if(StringUtils.isBlank(name)){
            return null;
        }
        for (ExternalPlatformMediaAccountEnum accountEnum : ExternalPlatformMediaAccountEnum.values()){
            if(accountEnum.name.equals(name)){
                return accountEnum.getType();
            }
        }
        return null;
    }

}