/**
 * Project Name:ssp-center-api
 * File Name:RemoteAccountSettlementService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年5月22日下午5:22:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountSettlementDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountMonthReportByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateCheckStatus;
import cn.com.duiba.tuia.ssp.center.api.dto.TuiaCompanyValueDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
/**
 * ClassName:RemoteAccountSettlementService <br/>
 * Function: 用户结算数据. <br/>
 * Date:     2017年5月22日 下午5:22:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAccountSettlementService {
    
    /**
     * 通过月账单IDS 查询结算数据
     * 
     * @param billIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountSettlementDto>> getSettlementList(List<Long> appIds,List<String> curDates,Long mediaId);

    /**
     * 查询一条用户结算数据
     *
     * @param appId
     * @param curDate
     * @param mediaId
     * @return
     * @since JDK 1.6
     *
     * @deprecated 这个方法后续版本中会被移除，现在已支持媒体该月可以生成多个代理结算单
     */
    @Deprecated
    DubboResult<AccountSettlementDto> getAccountSettlement(Long appId,String curDate,Long mediaId);

    /**
     * 通过app id和年月查询对应的结算金额
     */
    List<AccountSettlementDto> findListByAppIdAndDate(Long appId, String curDate);

    Boolean deleteByAppIdAndDate(Long appId, String curDate, List<Integer> settleStatusList);

    /**
     * 插入媒体结算信息
     */
    DubboResult<Boolean> insert(AccountSettlementDto accountSettlementDto);

    /**
     * 更新结算信息
     */
    DubboResult<Boolean> update(AccountSettlementDto accountSettlementDto);
    DubboResult<Boolean> updateById(AccountSettlementDto accountSettlementDto);

    /**
     * 通过App id和月份查询对应的结算后账单信息
     * 月份格式 YYYY-MM
     *
     * @deprecated 这个方法后续版本中会被移除，现在已支持媒体该月可以生成多个代理结算单
     */
    @Deprecated
    DubboResult<AccountSettlementDto> getSettlementByAppAndMonth(Long appId,String settledDate);

    /**
     * 修改审核状态
     */
    DubboResult<Boolean> updateSettlementStatus(ReqUpdateCheckStatus req);

    /**
     * 
     * selectAccountSettlementSum:(查询结算单总计). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> selectAccountSettlementSum(ReqAccountMonthReportByPage req);
    
    
    TuiaCompanyValueDto selectAllAccountSettlementSum(ReqAccountMonthReportByPage req);

    /**
     * 
     * getSettlementByCreateMonth:(生成日期查詢). <br/>
     *
     * @deprecated 这个方法后续版本中会被移除，现在已支持媒体该月可以生成多个代理结算单
     *
     * @author guyan
     * @param appId
     * @param createDate
     * @return
     */
    @Deprecated
    AccountSettlementDto getSettlementByCreateMonth(Long appId,String createDate);

    /**
     * 查询所有扩展字段attrJson
     */
    List<String> selectAllAccountSettlementAttrJson(ReqAccountMonthReportByPage req);

    /**
     * 查询所有账号各月份结算金额
     */
    List<AccountSettlementDto> listMediaSettlementBeforeDate(ReqAccountMonthReportByPage req);

    /**
     * @Description  根据起止日期查询总计实际分成金额
     * @Date 11:52 2020-06-16
     * @Param [req]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.AccountSettlementDto>
     **/
    AccountSettlementDto getMediaSettlementByDate(ReqAccountMonthReportByPage req);
}

