package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.constant.SlotPreWarnOrderEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 外部评分规则广告位得分统计表
 * 
 * @author YWG.MID.P
 * @date 2020-09-28 07:29:06
 */
@Data
public class SlotPreWarnPageReq extends BaseQueryDto {

	@ApiModelProperty(value = "广告位ID")
	private Long slotId;

	@ApiModelProperty(value = "广告位名称")
	private String slotName;

	@ApiModelProperty(value = "托管开启状态:0-关闭,1-开启")
	private Integer isHosting;

	@ApiModelProperty(value = "广告位ID集合")
	private List<Long> slotIds;

	@ApiModelProperty(value = "记录日期")
	private Date curDate;

	@ApiModelProperty(value = "媒体ID")
	private Long appId;

	@ApiModelProperty(value = "媒体名称")
	private String appName;

	@ApiModelProperty(value = "预警状态:0-正常数据,1-预警数据")
	private Integer isPreWarn;

	@ApiModelProperty(value = "建议来源.0-仅BI、1-仅风控、2-同时BI、风控")
	private Integer suggestSource;

	@ApiModelProperty(value = "排序方式。deviateRate偏离率、divisionExpect预期分成比例、divisionSuggest建议分成比例 、sharedSuggest建议分成价格、sharedExpect预期分成价格 、cheatFeeRate作弊消耗占比、 " +
			"divisionPriceSuggest风控建议计费价格、yesterdayExpectMediaIncome预计昨日媒体收入。默认偏离率降序")
	private String sort = SlotPreWarnOrderEnum.DEVIATE_RATE.getValue();

	@ApiModelProperty(value = "排序方式。desc降序，asc升序")
	private String order = "desc";

}
