package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ProduceDayBillDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotStatDailyByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotStatDataByPage;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteProduceDayBillService {

    DubboResult<Integer> batchInsert(List<ProduceDayBillDto> list);

    List<ProduceDayBillDto> selectDayBill(ReqSlotStatDailyByPage param);

    ProduceDayBillDto selectProduceDayBill(Long appId,Long slotId,Date curDate);

    Boolean updateProduceDayBill(ProduceDayBillDto dto);

    void saveProduceDayBill(ProduceDayBillDto dto);

    List<ProduceDayBillDto> select4UnAdaptable(List<Date> curDate, List<Long> slotIds);

    List<ProduceDayBillDto> selectListByDateAndSlotId(String startDate,String endDate,List<Long> slotIds);

    List<ProduceDayBillDto> selectNotUploadedSlot(String startDate,String endDate,String currentMonth,List<Long> slotIds);

    /**
     * @Description  未上传数据接口整合,解决remote接口参数截断问题
     * @Date 17:19 2020-10-13
     * @Param [req]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.ProduceDayBillDto>
     **/
    List<ProduceDayBillDto> selectNotUploadedSlotByReq(ReqSlotStatDataByPage req);


    void handleRecentlyChangedFinData(String startTime);

    int deleteById(Long id);
}
