package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 广告位活动问题类型
 *
 * @author zhangzhenghe
 * @since 2020-02-19 7:28 PM
 */
@AllArgsConstructor
@Getter
public enum SlotActivityProblemEnum {

    BAD_BENEFIT(1, "活动效益变差"),

    IMPROVE_PROPORTION(2, "优质活动占比需提升"),

    REPLACE_ACTIVITY(3, "长期未更换活动");

    private Integer type;

    private String  desc;

    public static List<Integer> getAllTypes() {
        return Arrays.stream(SlotActivityProblemEnum.values()).map(SlotActivityProblemEnum::getType).collect(Collectors.toList());
    }
}
