/**
 * Project Name:media-biz File Name:AccountSettlementDto.java Package Name:cn.com.duiba.tuia.media.domain
 * Date:2016年12月4日下午5:48:48 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:AccountSettlementDto <br/>
 * Function: 媒体用户结算. <br/>
 * Date: 2016年12月4日 下午5:48:48 <br/>
 *
 * @author guyan
 * @see
 * @since JDK 1.6
 */
public class AccountSettlementDto extends BaseDto {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -2303068775573177460L;

    /**
     * 待结算状态
     */
    public static final int SETTLEMENTS_STATUS_AWAITING = 0;
    /**
     * 结算中状态
     */
    public static final int SETTLEMENT_STATUS_DEFAULT = 1;
    /**
     * 拒绝结算状态
     */
    public static final int SETTLEMENT_STATUS_REFUSED = 2;
    /**
     * 已结算状态
     */
    public static final int SETTLEMENT_STATUS_PASS = 3;

    /**
     * 审核状态通过
     */
    public static final int AUDIT_STATUS_PASS = 1;
    /**
     * 审核状态拒绝
     */
    public static final int AUDIT_STATUS_REFUSED = 0;

    /**
     * 杭州最终收入
     */
    public static final int HZ_SETTLED_MEDIA_DIVIDE = 0;

    /**
     * 霍尔果斯最终收入
     */
    public static final int HEGS_SETTLED_MEDIA_DIVIDE = 1;

    /** 霍城兑捷最终收入 */
    public static final int   HCDJ_SETTLED_MEDIA_DIVIDE   = 2;

    /** 杭州变动前收入 */
    public static final int   HZ_SETTLED_MEDIA_BEFORE     = 3;

    /** 霍尔果斯变动前收入 */
    public static final int   HEGS_SETTLED_MEDIA_BEFORE   = 4;

    /** 霍城兑捷变动前收入 */
    public static final int   HCDJ_SETTLED_MEDIA_BEFORE   = 5;

    /**
     * 杭推理论收入 这玩意放这干嘛？
     */
    public static final int   HZ_EXPECT_INCOME = 6;
    /**
     * 霍推理论收入 这玩意放这干嘛？
     */
    public static final int   HEGS_EXPECT_INCOME = 7;
    /**
     * 兑捷理论收入 这玩意放这干嘛？
     */
    public static final int   HCDJ_EXPECT_INCOME = 8;

    /**
     * 加减款后的杭推理论收入 这玩意放这干嘛？
     */
    public static final int AFTER_CHANGE_HZ_EXPECT_INCOME = 9;
    /**
     * 加减款后的霍推理论收入 这玩意放这干嘛？
     */
    public static final int AFTER_CHANGE_HEGS_EXPECT_INCOME = 10;
    /**
     * 加减款后的兑捷理论收入 这玩意放这干嘛？
     */
    public static final int AFTER_CHANGE_HCDJ_EXPECT_INCOME = 11;

    /** 兑推最终收入 */
    public static final int DT_SETTLED_MEDIA_DIVIDE = 12;
    /**
     * 兑推理论收入 这玩意放这干嘛？
     */
    public static final int   DT_EXPECT_INCOME = 13;

    /** 兑推变动前收入 */
    public static final int   DT_SETTLED_MEDIA_BEFORE = 14;
    /**
     * 加减款后的兑推理论收入 这玩意放这干嘛？
     */
    public static final int   AFTER_CHANGE_DT_EXPECT_INCOME = 15;

    /** 媒体用户id */
    private Long              mediaId;
    /** 媒体id */
    private Long              appId;
    /** 结算月份 */
    private Date              settledDate;
    /** 结算后媒体分成 */
    private Long              settledMediaDivide;
    /** 金額 */
    private Long              amount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 结算状态：0-待结算，1-结算中，2-拒绝结算  3-已结算
     */
    private Integer settlementStatus;
    /**
     * 审核状态：0-通过，1-拒绝
     */
    private Integer auditStatus;
    /**
     * 结算人姓名
     */
    private String settlementPersonName;
    /**
     * 月报表Id
     */
    private Long reportId;
    /**
     * 线下打款金额
     */
    private Long offlineMoney;
    /**
     * 杭州结算后媒体分成
     */
    private Long hzSettledMediaDivide;

    /**霍尔果斯结算后媒体分成*/
    private Long              hegsSettledMediaDivide;

    /**霍城兑捷结算后媒体分成*/
    private Long hcdjSettledMediaDivide;

    /**兑推结算后媒体分成*/
    private Long duituiSettledMediaDivide;

    /**
     * 业务展示备注
     */
    private String showRemark;


    /**
     * 扩展属性值JSON对象
     */
    private String attrJson;

    /**0-无代理 1-代理*/
    private Byte agentSettleType;

    /** -1:无意义 0-杭推 1 霍推 2兑捷 */
    private Byte settleCompanyType;

    /** 图片证明备注,金额在10000以上是必填项*/
    private String pictureProofMark;


    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * settledDate.
     *
     * @return the settledDate
     * @since JDK 1.6
     */
    public Date getSettledDate() {
        return settledDate;
    }

    /**
     * settledDate.
     *
     * @param settledDate the settledDate to set
     * @since JDK 1.6
     */
    public void setSettledDate(Date settledDate) {
        this.settledDate = settledDate;
    }

    /**
     * settledMediaDivide.
     *
     * @return the settledMediaDivide
     * @since JDK 1.6
     */
    public Long getSettledMediaDivide() {
        return settledMediaDivide;
    }

    /**
     * settledMediaDivide.
     *
     * @param settledMediaDivide the settledMediaDivide to set
     * @since JDK 1.6
     */
    public void setSettledMediaDivide(Long settledMediaDivide) {
        this.settledMediaDivide = settledMediaDivide;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.6
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.6
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getSettlementStatus() {
        return settlementStatus;
    }

    /**
     * settlementStatus.
     *
     * @param settlementStatus the settlementStatus to set
     * @since JDK 1.6
     */
    public void setSettlementStatus(Integer settlementStatus) {
        this.settlementStatus = settlementStatus;
    }

    /**
     * auditStatus.
     *
     * @return the auditStatus
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    /**
     * settlementPersonName.
     *
     * @return the settlementPersonName
     * @since JDK 1.6
     */
    public String getSettlementPersonName() {
        return settlementPersonName;
    }

    /**
     * settlementPersonName.
     *
     * @param settlementPersonName the settlementPersonName to set
     * @since JDK 1.6
     */
    public void setSettlementPersonName(String settlementPersonName) {
        this.settlementPersonName = settlementPersonName;
    }

    /**
     * amount.
     *
     * @return the amount
     * @since JDK 1.6
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * amount.
     *
     * @param amount the amount to set
     * @since JDK 1.6
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * reportId.
     *
     * @return the reportId
     * @since JDK 1.6
     */
    public Long getReportId() {
        return reportId;
    }

    /**
     * reportId.
     *
     * @param reportId the reportId to set
     * @since JDK 1.6
     */
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public Long getOfflineMoney() {
        return offlineMoney;
    }

    public void setOfflineMoney(Long offlineMoney) {
        this.offlineMoney = offlineMoney;
    }

    public Long getHzSettledMediaDivide() {
        return hzSettledMediaDivide;
    }


    public void setHzSettledMediaDivide(Long hzSettledMediaDivide) {
        this.hzSettledMediaDivide = hzSettledMediaDivide;
    }

    public Long getHegsSettledMediaDivide() {
        return hegsSettledMediaDivide;
    }

    public void setHegsSettledMediaDivide(Long hegsSettledMediaDivide) {
        this.hegsSettledMediaDivide = hegsSettledMediaDivide;
    }

    public Long getHcdjSettledMediaDivide() {
        return hcdjSettledMediaDivide;
    }

    public void setHcdjSettledMediaDivide(final Long hcdjSettledMediaDivide) {
        this.hcdjSettledMediaDivide = hcdjSettledMediaDivide;
    }

    public Long getDuituiSettledMediaDivide() {
        return duituiSettledMediaDivide;
    }

    public void setDuituiSettledMediaDivide(Long duituiSettledMediaDivide) {
        this.duituiSettledMediaDivide = duituiSettledMediaDivide;
    }

    public Byte getAgentSettleType() {
        return agentSettleType;
    }

    public void setAgentSettleType(final Byte agentSettleType) {
        this.agentSettleType = agentSettleType;
    }

    public Byte getSettleCompanyType() {
        return settleCompanyType;
    }

    public void setSettleCompanyType(final Byte settleCompanyType) {
        this.settleCompanyType = settleCompanyType;
    }

    public String getShowRemark() {
        return showRemark;
    }

    public void setShowRemark(final String showRemark) {
        this.showRemark = showRemark;
    }

    public String getAttrJson() {
        return attrJson;
    }

    public void setAttrJson(final String attrJson) {
        this.attrJson = attrJson;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getPictureProofMark() {
        return pictureProofMark;
    }

    public void setPictureProofMark(String pictureProofMark) {
        this.pictureProofMark = pictureProofMark;
    }
}
