/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;

import java.util.List;

/**
 * 描述: 域名策略查询条件
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/25 10:00
 */
public class DomainWarningStrategyQuery extends BaseQueryDto {

    /* 域名标签 废弃*/
    private Long domainTag;
    private List<Long> domainTagList;
    /* 域名类型 1:投放域名；2:活动域名；3:落地页域名 */
    private Integer domainType;
    /* 域名场景屏蔽状态；wx,qq,wb,zfb,360,chrome */
    private String domainSceneStatus;
    private Integer deleted = 0;

    /**
     * 新标签ID
     */
    private Long tagId;

    /**
     * 新标签ID列表
     */
    private List<Long> tagIdList;

    public Long getDomainTag() {
        return domainTag;
    }

    public void setDomainTag(Long domainTag) {
        this.domainTag = domainTag;
    }

    public List<Long> getDomainTagList() {
        return domainTagList;
    }

    public void setDomainTagList(List<Long> domainTagList) {
        this.domainTagList = domainTagList;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public String getDomainSceneStatus() {
        return domainSceneStatus;
    }

    public void setDomainSceneStatus(String domainSceneStatus) {
        this.domainSceneStatus = domainSceneStatus;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public List<Long> getTagIdList() {
        return tagIdList;
    }

    public void setTagIdList(List<Long> tagIdList) {
        this.tagIdList = tagIdList;
    }
}
