package cn.com.duiba.tuia.ssp.center.api.dto.accountAmountVerify;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

public class ReqAmountVerifyInfo implements Serializable {

    /**
     * 账户金额ID
     */
    @ApiModelProperty(value = "账户金额ID", required = true)
    @NotNull(message = "账户验证金额ID不能为空")
    private Long id;


    /**
     * 类型：0-杭州 1-霍尔果斯  2-霍城兑捷 3-兑推
     * @see cn.com.duiba.tuia.ssp.center.api.constant.TuiaCompanyType
     */
    @ApiModelProperty(value = "类型：0-杭州 1-霍尔果斯 2-霍城兑捷 3-兑推", required = true)
    @NotNull(message = "类型不能为空")
    @Min(value = 0, message = "类型 的最小值为0")
    @Max(value = 3, message = "类型 的最大值为3")
    private Integer incomeSource;

    /**
     * 验证状态：0-待验证 1-验证中 2-验证通过
     */
    @ApiModelProperty(value = "验证状态：0-待验证 1-验证中 2-验证通过", required = true)
    @NotNull(message = "验证状态不能为空")
    @Min(value = 0, message = "验证状态 的最小值为0")
    @Max(value = 2, message = "验证状态 的最大值为2")
    private Integer verifyStatus;

    /**
     * 数据类型：0-正常确认  1-调账
     */
    @ApiModelProperty(value = "数据类型：0-正常确认  1-调账", required = true)
    @NotNull(message = "是否调账字段不能为空")
    @Range(min = 0, max = 1, message = "是否调账字段类型异常")
    private Integer recordType;

    /**
     * 疑问内容
     */
    private String doubtInfo;


    private Long mediaId;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public String getDoubtInfo() {
        return doubtInfo;
    }

    public void setDoubtInfo(String doubtInfo) {
        this.doubtInfo = doubtInfo;
    }

    public Integer getIncomeSource() {
        return incomeSource;
    }

    public void setIncomeSource(Integer incomeSource) {
        this.incomeSource = incomeSource;
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
