package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

@ApiModel
public class UndeadLinkSlotAndAppRsp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位名称
     */
    @ApiModelProperty(value = "广告位名称")
    private String slotName;
    /**
     * 广告位ID
     */
    @ApiModelProperty(value = "广告位ID")
    private Long slotId;

    /**
     * 媒体名称
     */
    @ApiModelProperty(value = "媒体名称")
    private String appName;
    /**
     * 媒体ID
     */
    @ApiModelProperty(value = "媒体ID")
    private Long appId;

    /**
     * 广告位类型名称
     */
    @ApiModelProperty(value = "媒体密钥")
    private String appKey;

    /**
     * 不死链接id
     */
    @ApiModelProperty(value = "不死链接id")
    private Long undeadLinkId;

    /**
     * 不死链接
     */
    @ApiModelProperty(value = "")
    private String undeadLink;

    private String undeadSlotLink;

    private String sceneType;

    private List<MediaTag>  carrierFlowTags;

    public List<MediaTag> getCarrierFlowTags() {
        return carrierFlowTags;
    }

    public void setCarrierFlowTags(List<MediaTag> carrierFlowTags) {
        this.carrierFlowTags = carrierFlowTags;
    }

    @ApiModel
    @Data
    @Builder
    public static class MediaTag {

        @ApiModelProperty(value = "标签ID")
        private String tagId;

        @ApiModelProperty(value = "标签名称", required = true)
        private String title;
    }

    public String getUndeadSlotLink() {
        return undeadSlotLink;
    }

    public void setUndeadSlotLink(String undeadSlotLink) {
        this.undeadSlotLink = undeadSlotLink;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Long getUndeadLinkId() {
        return undeadLinkId;
    }

    public void setUndeadLinkId(Long undeadLinkId) {
        this.undeadLinkId = undeadLinkId;
    }

    public String getUndeadLink() {
        return undeadLink;
    }

    public void setUndeadLink(String undeadLink) {
        this.undeadLink = undeadLink;
    }

    public String getSceneType() {
        return sceneType;
    }

    public void setSceneType(String sceneType) {
        this.sceneType = sceneType;
    }

    @Override public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
