package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author zhangliwei
 * @Description  审核表数据查询通用对象
 * @Date 15:56 2020-03-11
 * @Param
 * @return
 **/
@Data
public class ReqAbnormalAuditData implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -985200930961288893L;

    /** 媒体ID */
    private Long slotId;

    /**广告位ID集合**/
    @ApiModelProperty(value = "广告位ID集合")
    private List<Long> slotIds;

    @ApiModelProperty(value = "记录ID集合")
    private List<Long> recordsIds;


    /** The start date. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String startDate;

    /** The end date. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String endDate;

}
