package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ApiVersionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqApiVersionDto;

/**
 * ClassName: RemoteApiVersionService <br/>
 * Function: <br/>
 * Date: 2018年06月19日 下午5:04 <br/>
 *
 * @author lijian
 */
@AdvancedFeignClient
public interface RemoteApiVersionService {

    /**
     * 新增api打包记录
     * 
     * @param dto
     * @return
     */
    Integer insert(ApiVersionDto dto);

    /***
     * getLastVersionId:获取api最新包序号.
     * 
     * @param
     * @return
     */
    Long getLastVersionId();

    /***
     * 根据id删除api版本信息
     * 
     * @param id
     * @return
     */
    Integer delApiVersion(Long id);

    /***
     * 设置api包下载地址
     * 
     * @param id
     * @param apiPackageUrl
     * @return
     */
    Integer updatePackageUrl(Long id, String apiPackageUrl);

    /***
     * 设置api文档地址
     * 
     * @param id
     * @param apiDocUrl
     * @param apiPdfUrl
     */
    Integer updateApiDocUrl(Long id, String apiDocUrl, String apiPdfUrl);

    /***
     * 设置api备注信息
     * 
     * @param id
     * @param apiRemark
     * @return
     */
    Integer updateApiRemark(Long id, String apiRemark);

    /***
     * 分页查询api版本信息
     * 
     * @param reqApiVersionDto
     * @return
     */
    PageResultDto<ApiVersionDto> getApiVersionslist(ReqApiVersionDto reqApiVersionDto);

    /**
     * 获取当前的发布版本
     * 
     * @param reqApiVersionDto
     * @return
     */
    List<ApiVersionDto> getReleaseDto(ReqApiVersionDto reqApiVersionDto);

    /**
     * 发布
     * 
     * @param reqApiVersionDto
     * @return
     */
    Integer releaseApi(ReqApiVersionDto reqApiVersionDto);

}
