package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 推啊节点枚举
 * @Param
 * @return
 **/
@Getter
public enum TuiaMediaTypeEnum {
    /**
     * 券点击
     */
    ADVERT_CLICK(-1, "券点击"),
    /**
     * 落地页转化
     */
    LANDING_PAGE_CONVERSIONS(0, "落地页转化"),
    /**
     * 安装
     */
    INSTALL(1, "安装"),
    /**
     * 启动
     */
    START_UP(2, "启动"),
    /**
     * 注册
     */
    REGISTER(3, "注册"),
    /**
     * 激活
     */
    ACTIVATION(4, "激活"),
    /**
     * 登录
     */
    LOG_IN(5, "登录"),
    /**
     * 付费
     */
    PAY(6, "付费"),
    /**
     * 进件
     */
    INCOMING(7, "进件"),
    /**
     * 完件
     */
    COMPLETE(8, "完件"),
    /**
     * 签收
     */
    SIGN_FOR_RECEIPT(9, "签收"),
    /**
     * 拒签
     */
    VISA_REFUSAL(10, "拒签"),
    /**
     * 出单
     */
    ORDER(11, "出单"),
    /**
     * 应用唤起
     */
    APPLICATION_AROUSAL(20, "应用唤起"),
    /**
     * 首唤应用唤起
     */
    FIRST_APPLICATION_AROUSAL(21, "首唤应用唤起"),
    /**
     *
     */
    RETAINED_NEXT_DAY(22, "次日留存"),

    OCPC_DYNAMIC_POINT(-100, "广告OCPC出价O点"),
    ;
    private Integer subType;

    private String desc;

    TuiaMediaTypeEnum(Integer subType, String desc){
        this.subType = subType;
        this.desc = desc;
    }

}
