package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@Data
public class ProgrammaticMediaReportConfigDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtModified;
    /**
     * 删除标识 0-否 1-是
     */
    private Integer isDeleted;
    /**
     * 上报策略ID
     */
    private Long reportStrategyId;
    /**
     * 上报维度 1-全局维度 2- 广告资源维度 3-广告维度
     */
    @NotNull(message = "上报维度不能为空")
    private Integer reportDimension;
    /**
     * 标签ID
     */
    private String tagId;
    /**
     * 广告计划ID
     */
    private Long advertId;
    /**
     * 推啊上报节点
     */
    @NotNull(message = "推啊节点不能为空")
    private Integer tuiaType;
    /**
     * 媒体上报节点
     */
    @NotNull(message = "媒体节点不能为空")
    private String mediaType;
    /**
     * 上报概率
     */
    private Integer returnProbability;

    /**
     * 账户id
     */
    private String accountId;
    /**
     * 固定收益
     */
    private Long income;
    /**
     * 行业id
     */
    private Integer industry;
    /**
     * 推啊助攻节点
     */
    private Integer assistingSubtype;

    private Double returnProbabilityNew;

    /**
     * 阈值1，目前是给推啊节点上报占比用的
     */
    private Double thresholdOne;

    /**
     * 阈值2，目前是给antScore上报阈值用的
     */
    private Double thresholdTwo;


    private String areaCode;
    /**
     * 模型分层
     */
    private String dcvrLevel;
    /**
     * 签收分层
     */
    private String signRateLevel;

}
