/**
 * Project Name:ssp-center-api File Name:ReqMediaRewardScoreMonth.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年11月15日下午2:24:44 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqMediaRewardScoreMonth <br/>
 *
 * @author Administrator
 * @see
 * @since JDK 1.6
 */
@ApiModel
public class ReqMediaRewardScoreMonth extends BaseQueryDto {

    private static final long serialVersionUID = -7610857170246228343L;

    @ApiModelProperty(value = "媒体帐号邮箱", required = false)
    private String email;

    @ApiModelProperty(value = "媒体帐号ID", required = false)
    private Long mediaId;

    @ApiModelProperty(value = "媒体帐号ID列表", required = false)
    private List<Long> mediaIds;

    @ApiModelProperty(value = "规则ID", required = false)
    private Long mrsId;

    @ApiModelProperty(value = "策略类型 0月度|1季度")
    private Integer type;

    @ApiModelProperty(value = "开始时间2018-01/2018-Q1")
    private String startTime;

    @ApiModelProperty(value = "结束时间2018-02/2018-Q2")
    private String endTime;

    @ApiModelProperty(value = "当前月份（'2017-11'）", required = false)
    private String curMonth;

    @ApiModelProperty(value = "当前日期（'2017-11-11'）", required = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date curDate;

    @ApiModelProperty(value = "查询状态（0：待结算；1：待媒体运营负责人审核；2：待流量负责人审核；3：重新结算；4：已结算）", required = false)
    private Integer queryStatus;

    //结算状态
    @ApiModelProperty(value = "结算状态（0-待结算，1-待媒体运营负责人审核，2-待流量负责人审核，3-已结算）", required = false)
    private Integer settleStatus;

    public Integer getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(Integer settleStatus) {
        this.settleStatus = settleStatus;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public List<Long> getMediaIds() {
        return mediaIds;
    }

    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public String getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(String curMonth) {
        this.curMonth = curMonth;
    }

    public Long getMrsId() {
        return mrsId;
    }

    public void setMrsId(Long mrsId) {
        this.mrsId = mrsId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getQueryStatus() {
        return queryStatus;
    }

    public void setQueryStatus(Integer queryStatus) {
        this.queryStatus = queryStatus;
    }
}
