/**
 * Project Name:media-api File Name:RspSettledMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年11月30日下午3:52:36 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.constant.SsoFieldShieldPathEnum;
import cn.com.duiba.tuia.ssp.center.api.tool.DataMathUtil;
import cn.com.duiba.tuia.ssp.center.api.tool.StringTool;
import com.google.common.collect.Lists;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * ClassName:RspSettledMonthReportDto <br/>
 * Function: 已结算月报表. <br/>
 * Date: 2016年11月30日 下午3:52:36 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@SensitiveInfo(sensitiveFields = {"account","appName"})
public class SettledMonthReportRsp extends BaseAccountMonthReportRsp implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 370897234679755232L;

    /** 月发劵量 */
    private Long           monthAdvertCount;

    /** 月曝光数 */
    private Integer           monthShowCount;

    /** 月点击量 */
    private Integer           monthClickCount;

    /** 日点击uv总数 */
    private Integer           allDayClickUvCount;

    /** 月有效点击量 */
    private Integer           monthValidClickCount;

    /** 最终分成 */
    private Long              finalShare;

    private Long              platformFinalShare;

    /** 结算状态：0-待结算，1-默认结算，2-拒绝结算 */
    private Integer           checkStatus;

    /** 审核状态：0-拒绝，1-通过 */
    private Integer           auditStatus;

    /** 账户类型：0-普通用户 1-线下打款用户*/
    private Integer           isOffline;

    /** 线下打款金额 */
    private Long              offlineMoney;

    /** 广告位曝光  */
    private Long        actExposeCount;

    /** 广告位点击  */
    private Long        actClickCount;

    /** 广告位访问UV  */
    private Long        sdkUv;

    /** 活动广告券请求  */
    private Long        advertRequestCount;

    /** 发券成功率 */
    private Double        launchSuccessRate;

    /** 媒体CPM */
    private Double              mediaCPM;

    /** 媒体CPC */
    private Double              mediaCPC;

    /** 媒体UV单价 */
    private Double mediaUVPrice;

    /** 分成比例 */
    private Double divisionProportion;

    private Double platformDivisionProportion;

    /** 实际分成比例 */
    private Double actualProportion;

    private Double platformActualProportion;

    /** 结算拒绝原因 */
    private String rejectReason;

    /**用户类别*/
    private Integer accountType;

    /**调整金额*/
    private Long adjustmentAmount;

    /**税率*/
    private Integer taxRate;

    /** 纳税人类型 */
    private Integer taxpayerType;

    /**月账单生成日期*/
    private String gmtCreate;

    /**月账单结算日期*/
    private String currentDate;

    /**杭州实际分成*/
    private Long hzFinalShare;

    private Long platformHzFinalShare;

    /**霍尔果斯实际分成*/
    private Long hegsFinalShare;

    private Long platformHegsFinalShare;

    /**霍城兑捷实际分成*/
    private Long hcdjFinalShare;

    private Long platformHcdjFinalShare;

    /**兑推实际分成*/
    private Long duituiFinalShare;

    private Long platformDuituiFinalShare;

    /**原有广告消耗*/
    private Long originalAdConsume;

    private Long platformOriginalAdConsume;


    /**杭州广告消耗*/
    private Long hzAdConsume;

    private Long platformHzAdConsume;

    /**霍尔果斯广告消耗*/
    private Long hegsAdConsume;

    private Long platformHegsAdConsume;

    /**霍城兑捷广告消耗*/
    private Long hcdjAdConsume;

    private Long platformHcdjAdConsume;

    /**兑推广告消耗*/
    private Long duituiAdConsume;

    private Long platformDuituiAdConsume;

    /**杭州应得收入*/
    private Long hzConsumeTotal;

    private Long platformHzConsumeTotal;

    /**霍尔果斯应得收入*/
    private Long hegsConsumeTotal;

    private Long platformHegsConsumeTotal;

    /**霍城兑捷应得收入*/
    private Long hcdjConsumeTotal;

    private Long platformHcdjConsumeTotal;

    /**兑推应得收入*/
    private Long duituiConsumeTotal;

    private Long platformDuituiConsumeTotal;

    /**杭州预计收入*/
    private Long hzExConsumeTotal;

    private Long platformHzExConsumeTotal;

    /**霍尔果斯预计收入*/
    private Long hegsExConsumeTotal;

    private Long platformHegsExConsumeTotal;

    /**霍城兑捷预计收入*/
    private Long hcdjExConsumeTotal;

    private Long platformHcdjExConsumeTotal;

    /**兑推预计收入*/
    private Long duituiExConsumeTotal;

    private Long platformDuituiExConsumeTotal;

    /** 原有现金消耗 */
    private Long  originalCashConsume;

    private Long  platformOriginalCashConsume;

    /**
     * 原有现金分成比例 = 媒体应得收入 / 原有现金消耗
     */
    private Double cashProfitSharingRatioOriginal;

    /** 现金消耗 */
    private Long  cashConsume;

    private Long  platformCashConsume;
    /** 杭州现金消耗*/
    private Long   hzCashConsume;

    private Long   platformHzCashConsume;
    /** 霍尔果斯现金消耗*/
    private Long   hegsCashConsume;

    private Long   platformHegsCashConsume;
    /** 霍城兑捷现金消耗*/
    private Long   hcdjCashConsume;

    private Long   platformHcdjCashConsume;
    /** 兑推现金消耗*/
    private Long   duituiCashConsume;

    private Long   platformDuituiCashConsume;
    /** 分成比例（现金)*/
    private Double divisionCashProportion;

    private Double platformDivisionCashProportion;


    /**
     * 杭州实际收入(调账后)
     */
    private Long hzFinalShareAdjusted;

    private Long platformHzFinalShareAdjusted;
    /**
     * 霍城兑捷实际收入(调账后)
     */
    private Long hcdjFinalShareAdjusted;

    private Long platformHcdjFinalShareAdjusted;
    /**
     * 霍尔果斯实际收入(调账后)
     */
    private Long hegsFinalShareAdjusted;

    private Long platformHegsFinalShareAdjusted;
    /**
     * 兑推实际收入(调账后)
     */
    private Long duituiFinalShareAdjusted;

    private Long platformDuituiFinalShareAdjusted;
    /**
     * 媒体实际收入(调账后)
     */
    private Long finalShareAdjusted;

    private Long platformFinalShareAdjusted;
    /**
     * 杭州调整金额
     */
    private Long hzAdjust;

    private Long platformHzAdjust;
    /**
     * 霍城兑捷调整金额
     */
    private Long hcdjAdjust;

    private Long platformHcdjAdjust;
    /**
     * 霍尔果斯调整金额
     */
    private Long hegsAdjust;

    private Long platformHegsAdjust;
    /**
     * 兑推调整金额
     */
    private Long duituiAdjust;

    private Long platformDuituiAdjust;
    /**
     * 媒体调整金额
     */
    private Long adjust;

    private Long platformAdjust;

    /**
     * 现金分成区间
     **/
    private String cashDivisionSection;

    private String platformCashDivisionSection;

    /**业务展示备注*/

    private String showRemark;

    /**图片证明备注*/

    private String pictureProofMark;

    /**扩展属性Json对象*/

    private String attrJson;

    /**客户类型**/
    private Integer clientType;

    /**
     * 理论消耗
     */
    private Long theoryConsume;
    /**
     * 理论消耗分成比例
     */
    private Float theoryConsumeShareRatio;

    /**
     * 媒体负责人
     */
    private List<MediaAdminDto> mediaAdminDtoList;

    /**主要运营负责人*/
    private String            mediaManagerName;
    /**媒介负责人*/
    private String            mediumName;


    public Long getPlatformAdjust() {
        return platformAdjust;
    }

    public void setPlatformAdjust(Long platformAdjust) {
        this.platformAdjust = platformAdjust;
    }

    public Long getPlatformFinalShare() {
        return platformFinalShare;
    }

    public void setPlatformFinalShare(Long platformFinalShare) {
        this.platformFinalShare = platformFinalShare;
    }

    public Double getPlatformActualProportion() {
        return platformActualProportion;
    }

    public void setPlatformActualProportion(Double platformActualProportion) {
        this.platformActualProportion = platformActualProportion;
    }

    public Long getPlatformHzFinalShare() {
        return platformHzFinalShare;
    }

    public void setPlatformHzFinalShare(Long platformHzFinalShare) {
        this.platformHzFinalShare = platformHzFinalShare;
    }

    public Long getPlatformHegsFinalShare() {
        return platformHegsFinalShare;
    }

    public void setPlatformHegsFinalShare(Long platformHegsFinalShare) {
        this.platformHegsFinalShare = platformHegsFinalShare;
    }

    public Long getPlatformHcdjFinalShare() {
        return platformHcdjFinalShare;
    }

    public void setPlatformHcdjFinalShare(Long platformHcdjFinalShare) {
        this.platformHcdjFinalShare = platformHcdjFinalShare;
    }

    public Long getPlatformDuituiFinalShare() {
        return platformDuituiFinalShare;
    }

    public void setPlatformDuituiFinalShare(Long platformDuituiFinalShare) {
        this.platformDuituiFinalShare = platformDuituiFinalShare;
    }

    public Long getPlatformOriginalAdConsume() {
        return platformOriginalAdConsume;
    }

    public void setPlatformOriginalAdConsume(Long platformOriginalAdConsume) {
        this.platformOriginalAdConsume = platformOriginalAdConsume;
    }

    public Long getPlatformHzFinalShareAdjusted() {
        return platformHzFinalShareAdjusted;
    }

    public void setPlatformHzFinalShareAdjusted(Long platformHzFinalShareAdjusted) {
        this.platformHzFinalShareAdjusted = platformHzFinalShareAdjusted;
    }

    public Long getPlatformHcdjFinalShareAdjusted() {
        return platformHcdjFinalShareAdjusted;
    }

    public void setPlatformHcdjFinalShareAdjusted(Long platformHcdjFinalShareAdjusted) {
        this.platformHcdjFinalShareAdjusted = platformHcdjFinalShareAdjusted;
    }

    public Long getPlatformHegsFinalShareAdjusted() {
        return platformHegsFinalShareAdjusted;
    }

    public void setPlatformHegsFinalShareAdjusted(Long platformHegsFinalShareAdjusted) {
        this.platformHegsFinalShareAdjusted = platformHegsFinalShareAdjusted;
    }

    public Long getPlatformDuituiFinalShareAdjusted() {
        return platformDuituiFinalShareAdjusted;
    }

    public void setPlatformDuituiFinalShareAdjusted(Long platformDuituiFinalShareAdjusted) {
        this.platformDuituiFinalShareAdjusted = platformDuituiFinalShareAdjusted;
    }

    public Long getPlatformFinalShareAdjusted() {
        return platformFinalShareAdjusted;
    }

    public void setPlatformFinalShareAdjusted(Long platformFinalShareAdjusted) {
        this.platformFinalShareAdjusted = platformFinalShareAdjusted;
    }

    public Long getPlatformHzAdjust() {
        return platformHzAdjust;
    }

    public void setPlatformHzAdjust(Long platformHzAdjust) {
        this.platformHzAdjust = platformHzAdjust;
    }

    public Long getPlatformHcdjAdjust() {
        return platformHcdjAdjust;
    }

    public void setPlatformHcdjAdjust(Long platformHcdjAdjust) {
        this.platformHcdjAdjust = platformHcdjAdjust;
    }

    public Long getPlatformHegsAdjust() {
        return platformHegsAdjust;
    }

    public void setPlatformHegsAdjust(Long platformHegsAdjust) {
        this.platformHegsAdjust = platformHegsAdjust;
    }

    public Long getPlatformDuituiAdjust() {
        return platformDuituiAdjust;
    }

    public void setPlatformDuituiAdjust(Long platformDuituiAdjust) {
        this.platformDuituiAdjust = platformDuituiAdjust;
    }

    public Double getPlatformDivisionProportion() {
        return platformDivisionProportion;
    }

    public void setPlatformDivisionProportion(Double platformDivisionProportion) {
        this.platformDivisionProportion = platformDivisionProportion;
    }

    public Long getPlatformHzAdConsume() {
        return platformHzAdConsume;
    }

    public void setPlatformHzAdConsume(Long platformHzAdConsume) {
        this.platformHzAdConsume = platformHzAdConsume;
    }

    public Long getPlatformHegsAdConsume() {
        return platformHegsAdConsume;
    }

    public void setPlatformHegsAdConsume(Long platformHegsAdConsume) {
        this.platformHegsAdConsume = platformHegsAdConsume;
    }

    public Long getPlatformHcdjAdConsume() {
        return platformHcdjAdConsume;
    }

    public void setPlatformHcdjAdConsume(Long platformHcdjAdConsume) {
        this.platformHcdjAdConsume = platformHcdjAdConsume;
    }

    public Long getPlatformDuituiAdConsume() {
        return platformDuituiAdConsume;
    }

    public void setPlatformDuituiAdConsume(Long platformDuituiAdConsume) {
        this.platformDuituiAdConsume = platformDuituiAdConsume;
    }

    public Long getPlatformHzConsumeTotal() {
        return platformHzConsumeTotal;
    }

    public void setPlatformHzConsumeTotal(Long platformHzConsumeTotal) {
        this.platformHzConsumeTotal = platformHzConsumeTotal;
    }

    public Long getPlatformHegsConsumeTotal() {
        return platformHegsConsumeTotal;
    }

    public void setPlatformHegsConsumeTotal(Long platformHegsConsumeTotal) {
        this.platformHegsConsumeTotal = platformHegsConsumeTotal;
    }

    public Long getPlatformHcdjConsumeTotal() {
        return platformHcdjConsumeTotal;
    }

    public void setPlatformHcdjConsumeTotal(Long platformHcdjConsumeTotal) {
        this.platformHcdjConsumeTotal = platformHcdjConsumeTotal;
    }

    public Long getPlatformDuituiConsumeTotal() {
        return platformDuituiConsumeTotal;
    }

    public void setPlatformDuituiConsumeTotal(Long platformDuituiConsumeTotal) {
        this.platformDuituiConsumeTotal = platformDuituiConsumeTotal;
    }

    public Long getPlatformHzExConsumeTotal() {
        return platformHzExConsumeTotal;
    }

    public void setPlatformHzExConsumeTotal(Long platformHzExConsumeTotal) {
        this.platformHzExConsumeTotal = platformHzExConsumeTotal;
    }

    public Long getPlatformHegsExConsumeTotal() {
        return platformHegsExConsumeTotal;
    }

    public void setPlatformHegsExConsumeTotal(Long platformHegsExConsumeTotal) {
        this.platformHegsExConsumeTotal = platformHegsExConsumeTotal;
    }

    public Long getPlatformHcdjExConsumeTotal() {
        return platformHcdjExConsumeTotal;
    }

    public void setPlatformHcdjExConsumeTotal(Long platformHcdjExConsumeTotal) {
        this.platformHcdjExConsumeTotal = platformHcdjExConsumeTotal;
    }

    public Long getPlatformDuituiExConsumeTotal() {
        return platformDuituiExConsumeTotal;
    }

    public void setPlatformDuituiExConsumeTotal(Long platformDuituiExConsumeTotal) {
        this.platformDuituiExConsumeTotal = platformDuituiExConsumeTotal;
    }

    public Long getPlatformOriginalCashConsume() {
        return platformOriginalCashConsume;
    }

    public void setPlatformOriginalCashConsume(Long platformOriginalCashConsume) {
        this.platformOriginalCashConsume = platformOriginalCashConsume;
    }

    public Long getPlatformCashConsume() {
        return platformCashConsume;
    }

    public void setPlatformCashConsume(Long platformCashConsume) {
        this.platformCashConsume = platformCashConsume;
    }

    public Long getPlatformHzCashConsume() {
        return platformHzCashConsume;
    }

    public void setPlatformHzCashConsume(Long platformHzCashConsume) {
        this.platformHzCashConsume = platformHzCashConsume;
    }

    public Long getPlatformHegsCashConsume() {
        return platformHegsCashConsume;
    }

    public void setPlatformHegsCashConsume(Long platformHegsCashConsume) {
        this.platformHegsCashConsume = platformHegsCashConsume;
    }

    public Long getPlatformHcdjCashConsume() {
        return platformHcdjCashConsume;
    }

    public void setPlatformHcdjCashConsume(Long platformHcdjCashConsume) {
        this.platformHcdjCashConsume = platformHcdjCashConsume;
    }

    public Long getPlatformDuituiCashConsume() {
        return platformDuituiCashConsume;
    }

    public void setPlatformDuituiCashConsume(Long platformDuituiCashConsume) {
        this.platformDuituiCashConsume = platformDuituiCashConsume;
    }

    public Double getPlatformDivisionCashProportion() {
        return platformDivisionCashProportion;
    }

    public void setPlatformDivisionCashProportion(Double platformDivisionCashProportion) {
        this.platformDivisionCashProportion = platformDivisionCashProportion;
    }

    public String getPlatformCashDivisionSection() {
        return platformCashDivisionSection;
    }

    public void setPlatformCashDivisionSection(String platformCashDivisionSection) {
        this.platformCashDivisionSection = platformCashDivisionSection;
    }

    public String getMediumName() {
        return mediumName;
    }

    public void setMediumName(String mediumName) {
        this.mediumName = mediumName;
    }

    public String getMediaManagerName() {
        return mediaManagerName;
    }

    public void setMediaManagerName(String mediaManagerName) {
        this.mediaManagerName = mediaManagerName;
    }

    public Long getOriginalAdConsume() {
        return originalAdConsume;
    }

    public void setOriginalAdConsume(Long originalAdConsume) {
        this.originalAdConsume = originalAdConsume;
    }

    public Long getOriginalCashConsume() {
        return originalCashConsume;
    }

    public void setOriginalCashConsume(Long originalCashConsume) {
        this.originalCashConsume = originalCashConsume;
    }

    public Double getCashProfitSharingRatioOriginal() {
        return cashProfitSharingRatioOriginal;
    }

    public void setCashProfitSharingRatioOriginal(Double cashProfitSharingRatioOriginal) {
        this.cashProfitSharingRatioOriginal = cashProfitSharingRatioOriginal;
    }

    public List<MediaAdminDto> getMediaAdminDtoList() {
        return mediaAdminDtoList;
    }

    public void setMediaAdminDtoList(List<MediaAdminDto> mediaAdminDtoList) {
        this.mediaAdminDtoList = mediaAdminDtoList;
    }

    public Long getTheoryConsume() {
        return theoryConsume;
    }

    public void setTheoryConsume(Long theoryConsume) {
        this.theoryConsume = theoryConsume;
    }

    public Float getTheoryConsumeShareRatio() {
        return theoryConsumeShareRatio;
    }

    public void setTheoryConsumeShareRatio(Float theoryConsumeShareRatio) {
        this.theoryConsumeShareRatio = theoryConsumeShareRatio;
    }

    public String getShowRemark() {
        return showRemark;
    }

    public String getAttrJson() {
        return attrJson;
    }

    public void setShowRemark(String showRemark) {
        this.showRemark = showRemark;
    }

    public void setAttrJson(String attrJson) {
        this.attrJson = attrJson;
    }

    /**
     * 平台利润
     */
    private Long platformProfit;

    private Long platformPlatformProfit;


    public Long getPlatformPlatformProfit() {
        return DataMathUtil.calculateProfitData(this.getPlatformOriginalCashConsume(),this.finalShare);
    }

    public void setPlatformPlatformProfit(Long platformPlatformProfit) {
        this.platformPlatformProfit = platformPlatformProfit;
    }

    public Long getPlatformProfit() {
        return DataMathUtil.calculateProfitData(this.getOriginalCashConsume(),this.finalShare);
    }

    public void setPlatformProfit(Long platformProfit) {
        this.platformProfit = platformProfit;
    }

    public Long getCashConsume() {
        return cashConsume;
    }

    public void setCashConsume(Long cashConsume) {
        this.cashConsume = cashConsume;
    }

    public Long getHzCashConsume() {
        return hzCashConsume;
    }

    public void setHzCashConsume(Long hzCashConsume) {
        this.hzCashConsume = hzCashConsume;
    }

    public Long getHegsCashConsume() {
        return hegsCashConsume;
    }

    public void setHegsCashConsume(Long hegsCashConsume) {
        this.hegsCashConsume = hegsCashConsume;
    }

    public Double getDivisionCashProportion() {
        return divisionCashProportion;
    }

    public void setDivisionCashProportion(Double divisionCashProportion) {
        this.divisionCashProportion = divisionCashProportion;
    }

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * auditStatus.
     *
     * @return the auditStatus
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Long getMonthAdvertCount() {
        return monthAdvertCount;
    }

    public void setMonthAdvertCount(Long monthAdvertCount) {
        this.monthAdvertCount = monthAdvertCount;
    }

    public Integer getMonthShowCount() {
        return monthShowCount;
    }

    public void setMonthShowCount(Integer monthShowCount) {
        this.monthShowCount = monthShowCount;
    }

    public Integer getMonthClickCount() {
        return monthClickCount;
    }

    public void setMonthClickCount(Integer monthClickCount) {
        this.monthClickCount = monthClickCount;
    }

    public Integer getAllDayClickUvCount() {
        return allDayClickUvCount;
    }

    public void setAllDayClickUvCount(Integer allDayClickUvCount) {
        this.allDayClickUvCount = allDayClickUvCount;
    }

    public Integer getMonthValidClickCount() {
        return monthValidClickCount;
    }

    public void setMonthValidClickCount(Integer monthValidClickCount) {
        this.monthValidClickCount = monthValidClickCount;
    }

    public Long getFinalShare() {
        return finalShare;
    }

    public void setFinalShare(Long finalShare) {
        this.finalShare = finalShare;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Long getOfflineMoney() {
        return offlineMoney;
    }

    public void setOfflineMoney(Long offlineMoney) {
        this.offlineMoney = offlineMoney;
    }

    public Long getActExposeCount() {
        return actExposeCount;
    }

    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    public Long getActClickCount() {
        return actClickCount;
    }

    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    public Double getLaunchSuccessRate() {
        return launchSuccessRate;
    }

    public void setLaunchSuccessRate(Double launchSuccessRate) {
        this.launchSuccessRate = launchSuccessRate;
    }

    public Double getMediaCPM() {
        return mediaCPM;
    }

    public void setMediaCPM(Double mediaCPM) {
        this.mediaCPM = mediaCPM;
    }

    public Double getMediaCPC() {
        return mediaCPC;
    }

    public void setMediaCPC(Double mediaCPC) {
        this.mediaCPC = mediaCPC;
    }

    public Double getMediaUVPrice() {
        return mediaUVPrice;
    }

    public void setMediaUVPrice(Double mediaUVPrice) {
        this.mediaUVPrice = mediaUVPrice;
    }

    public Double getDivisionProportion() {
        return divisionProportion;
    }

    public void setDivisionProportion(Double divisionProportion) {
        this.divisionProportion = divisionProportion;
    }

    public Double getActualProportion() {
        return actualProportion;
    }

    public void setActualProportion(Double actualProportion) {
        this.actualProportion = actualProportion;
    }

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Integer getAccountType() {
        return accountType;
    }


    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getAdjustmentAmount() {
        return adjustmentAmount;
    }


    public void setAdjustmentAmount(Long adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public Integer getTaxRate() {
        return taxRate;
    }


    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    public String getGmtCreate() {
        return gmtCreate;
    }


    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getCurrentDate() {
        return currentDate;
    }


    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }
    public Long getHzFinalShare() {
        return hzFinalShare;
    }


    public void setHzFinalShare(Long hzFinalShare) {
        this.hzFinalShare = hzFinalShare;
    }


    public Long getHegsFinalShare() {
        return hegsFinalShare;
    }


    public void setHegsFinalShare(Long hegsFinalShare) {
        this.hegsFinalShare = hegsFinalShare;
    }

    public Long getHegsAdConsume() {
        return hegsAdConsume;
    }

    public void setHegsAdConsume(Long hegsAdConsume) {
        this.hegsAdConsume = hegsAdConsume;
    }

    public Long getHzAdConsume() {
        return hzAdConsume;
    }

    public void setHzAdConsume(Long hzAdConsume) {
        this.hzAdConsume = hzAdConsume;
    }

    public Long getHzConsumeTotal() {
        return hzConsumeTotal;
    }

    public void setHzConsumeTotal(Long hzConsumeTotal) {
        this.hzConsumeTotal = hzConsumeTotal;
    }

    public Long getHegsConsumeTotal() {
        return hegsConsumeTotal;
    }

    public void setHegsConsumeTotal(Long hegsConsumeTotal) {
        this.hegsConsumeTotal = hegsConsumeTotal;
    }

    public Long getHzExConsumeTotal() {
        return hzExConsumeTotal;
    }

    public void setHzExConsumeTotal(Long hzExConsumeTotal) {
        this.hzExConsumeTotal = hzExConsumeTotal;
    }

    public Long getHegsExConsumeTotal() {
        return hegsExConsumeTotal;
    }

    public void setHegsExConsumeTotal(Long hegsExConsumeTotal) {
        this.hegsExConsumeTotal = hegsExConsumeTotal;
    }

    public Long getHcdjFinalShare() {
        return hcdjFinalShare;
    }

    public void setHcdjFinalShare(final Long hcdjFinalShare) {
        this.hcdjFinalShare = hcdjFinalShare;
    }

    public Long getHcdjAdConsume() {
        return hcdjAdConsume;
    }

    public void setHcdjAdConsume(final Long hcdjAdConsume) {
        this.hcdjAdConsume = hcdjAdConsume;
    }

    public Long getHcdjConsumeTotal() {
        return hcdjConsumeTotal;
    }

    public void setHcdjConsumeTotal(final Long hcdjConsumeTotal) {
        this.hcdjConsumeTotal = hcdjConsumeTotal;
    }

    public Long getHcdjExConsumeTotal() {
        return hcdjExConsumeTotal;
    }

    public void setHcdjExConsumeTotal(final Long hcdjExConsumeTotal) {
        this.hcdjExConsumeTotal = hcdjExConsumeTotal;
    }

    public Long getHcdjCashConsume() {
        return hcdjCashConsume;
    }

    public void setHcdjCashConsume(final Long hcdjCashConsume) {
        this.hcdjCashConsume = hcdjCashConsume;
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(Integer clientType) {
        this.clientType = clientType;
    }

    public String getCashDivisionSection() {
        return cashDivisionSection;
    }

    public void setCashDivisionSection(String cashDivisionSection) {
        this.cashDivisionSection = cashDivisionSection;
    }

    public Long getHzFinalShareAdjusted() {
        return hzFinalShareAdjusted;
    }

    public void setHzFinalShareAdjusted(Long hzFinalShareAdjusted) {
        this.hzFinalShareAdjusted = hzFinalShareAdjusted;
    }

    public Long getHcdjFinalShareAdjusted() {
        return hcdjFinalShareAdjusted;
    }

    public void setHcdjFinalShareAdjusted(Long hcdjFinalShareAdjusted) {
        this.hcdjFinalShareAdjusted = hcdjFinalShareAdjusted;
    }

    public Long getHegsFinalShareAdjusted() {
        return hegsFinalShareAdjusted;
    }

    public void setHegsFinalShareAdjusted(Long hegsFinalShareAdjusted) {
        this.hegsFinalShareAdjusted = hegsFinalShareAdjusted;
    }

    public Long getFinalShareAdjusted() {
        return finalShareAdjusted;
    }

    public void setFinalShareAdjusted(Long finalShareAdjusted) {
        this.finalShareAdjusted = finalShareAdjusted;
    }

    public Long getHzAdjust() {
        return hzAdjust;
    }

    public void setHzAdjust(Long hzAdjust) {
        this.hzAdjust = hzAdjust;
    }

    public Long getHcdjAdjust() {
        return hcdjAdjust;
    }

    public void setHcdjAdjust(Long hcdjAdjust) {
        this.hcdjAdjust = hcdjAdjust;
    }

    public Long getHegsAdjust() {
        return hegsAdjust;
    }

    public void setHegsAdjust(Long hegsAdjust) {
        this.hegsAdjust = hegsAdjust;
    }

    public Long getAdjust() {
        return adjust;
    }

    public void setAdjust(Long adjust) {
        this.adjust = adjust;
    }

    public Long getDuituiFinalShare() {
        return duituiFinalShare;
    }

    public void setDuituiFinalShare(Long duituiFinalShare) {
        this.duituiFinalShare = duituiFinalShare;
    }

    public Long getDuituiAdConsume() {
        return duituiAdConsume;
    }

    public void setDuituiAdConsume(Long duituiAdConsume) {
        this.duituiAdConsume = duituiAdConsume;
    }

    public Long getDuituiConsumeTotal() {
        return duituiConsumeTotal;
    }

    public void setDuituiConsumeTotal(Long duituiConsumeTotal) {
        this.duituiConsumeTotal = duituiConsumeTotal;
    }

    public Long getDuituiExConsumeTotal() {
        return duituiExConsumeTotal;
    }

    public void setDuituiExConsumeTotal(Long duituiExConsumeTotal) {
        this.duituiExConsumeTotal = duituiExConsumeTotal;
    }

    public Long getDuituiCashConsume() {
        return duituiCashConsume;
    }

    public void setDuituiCashConsume(Long duituiCashConsume) {
        this.duituiCashConsume = duituiCashConsume;
    }

    public Long getDuituiFinalShareAdjusted() {
        return duituiFinalShareAdjusted;
    }

    public void setDuituiFinalShareAdjusted(Long duituiFinalShareAdjusted) {
        this.duituiFinalShareAdjusted = duituiFinalShareAdjusted;
    }

    public Long getDuituiAdjust() {
        return duituiAdjust;
    }

    public void setDuituiAdjust(Long duituiAdjust) {
        this.duituiAdjust = duituiAdjust;
    }

    /**
     * 组装待结算月账单，结算审核，已结算月账单
     *
     * @return
     */
    public List<String> installHidFileds(String path) {
        String dest=null;
        List<String> destList=Lists.newArrayList();
        // 媒体待结算月账单
        // 媒体CPM、媒体CPC、媒体UV单价、媒体预计收入、霍尔果斯预计收入、杭州预计收入、媒体应得收入、
        // 霍城兑捷预计收入、霍尔果斯应得收入、杭州应得收入、霍城兑捷应得收入、分成比例、
        // 现金消耗、杭州现金消耗、霍尔果斯现金消耗、霍城兑捷现金消耗、分成比例（现金）
        if (Objects.equals(path,SsoFieldShieldPathEnum.PATH_TYPE_NO_CHECK_MONTH_REPORT.getPath())) {
            dest=StringTool.join("mediaCPM","mediaCPC","mediaUVPrice","preShare","hcdjExConsumeTotal","duituiExConsumeTotal",
                    "hegsExConsumeTotal","hzExConsumeTotal","justlyShare","hegsConsumeTotal","hzConsumeTotal",
                    "hcdjConsumeTotal","duituiConsumeTotal","divisionProportion", "cashConsume","hzCashConsume","hegsCashConsume",
                    "hcdjCashConsume","duituiCashConsume","divisionCashProportion");
        }
        // 结算中月账单
        //媒体CPM、媒体CPC、媒体UV单价、媒体预计收入、霍尔果斯预计收入、杭州预计收入、霍城兑捷预计收入、
        // 媒体应得收入、霍尔果斯应得收入、杭州应得收入、霍城兑捷应得收入、分成比例
        if (Objects.equals(path,SsoFieldShieldPathEnum.PATH_TYPE_CHECKING_MONTH_REPORT.getPath())) {
            dest=StringTool.join("mediaCPM","mediaCPC","mediaUVPrice","preShare",
                    "hegsExConsumeTotal","hzExConsumeTotal","hzExConsumeTotal","hcdjExConsumeTotal","duituiExConsumeTotal",
                    "justlyShare","hegsConsumeTotal","hzConsumeTotal","hcdjConsumeTotal","duituiConsumeTotal","divisionProportion");
        }
        //已结算月账单
        //媒体预计收入、媒体应得收入、调整分成金额、媒体实际分成、霍尔果斯媒体实际收入、杭州媒体实际收入 霍城兑捷媒体实际收入 、
        // 分成比例、实际分成比例、平台利润
        if (Objects.equals(path,SsoFieldShieldPathEnum.PATH_TYPE_CHECKED_MONTH_REPORT.getPath())) {
            dest=StringTool.join("preShare","justlyShare","adjustmentAmount","finalShare",
                    "hegsFinalShare","hzFinalShare","hcdjFinalShare","duituiFinalShare","divisionProportion",
                    "actualProportion","platformProfit","cashProfitSharingRatioOriginal");
        }
        if (Objects.nonNull(dest)){
            return StringTool.getStringListByStr(dest);
        }
        return destList;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getPictureProofMark() {
        return pictureProofMark;
    }

    public void setPictureProofMark(String pictureProofMark) {
        this.pictureProofMark = pictureProofMark;
    }
}
