package cn.com.duiba.tuia.ssp.center.api.params.dmp;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/11/20.
 */
public class PageParam implements Serializable {
    private Integer pageIndex = 1;
    private Integer pageSize = 100;

    public Integer getOffset() {
        return (getPageIndex() - 1) * getPageSize();
    }

    public Integer getPageIndex() {
        return Objects.isNull(pageIndex) ? 1 : pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return Objects.isNull(pageSize) ? 100 : pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
