package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.enums.DockingStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.time.*;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Objects;

/**
 * 条件信息 :: 获取条件
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class GainCondition implements Serializable {

    /**
     * 类别 Id · 识别码
     */
    private String sortId;

    /**
     * 时间戳 ( ms:毫秒 )
     * -- 月份日期 ( ms:毫秒 ) 时间戳.
     */
    private Long date;

    /**
     * 状态值 · 识别码
     * -- 可选值 : { "00": "未接入", "10": "已接入 · 无消耗", "11": "已接入 · 有消耗" }.
     */
    private String status;

    /**
     * 对接状态
     * -- { 0 : 未接入 , 1 : 已接入 }
     */
    private Integer dockingStatus;

    /**
     * 消耗状态
     * -- { 0 : 无消耗 , 1 : 有消耗 }
     */
    private Integer consumeStatus;

    /**
     * App Id 集合
     */
    private List<String> appIdSet;

    public GainCondition(String sortId, Long date, DockingStatusEnum dockingStatus) {
        this.sortId = sortId;
        this.date = date;
        if (Objects.isNull(dockingStatus)) {
            return;
        }
        this.dockingStatus = dockingStatus.docking();
        this.consumeStatus = dockingStatus.consume();
    }

    public GainCondition(Integer consumeStatus, List<String> appIdSet) {
        this.consumeStatus = consumeStatus;
        this.appIdSet = appIdSet;
    }

    /**
     * 处理时间
     * -- 获取时间戳 ( ms:毫秒 ) 当前月份最后一天的最后一毫秒 ( ms:毫秒 ) 时间戳.
     */
    public void handleDate() {
        if (Objects.isNull(getDate())) {
            return;
        }
        LocalDate localDate = Instant.ofEpochMilli(this.getDate()).atZone(ZoneOffset.ofHours(8)).toLocalDate();
        LocalDate lastDay = localDate.with(TemporalAdjusters.lastDayOfMonth());
        this.setDate(LocalDateTime.of(lastDay, LocalTime.MAX).toInstant(ZoneOffset.of("+8")).toEpochMilli());
    }

}
