package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

/**
 * 发票追踪 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class InvoiceTrackingDto implements Serializable {

    private static final long serialVersionUID = 6473093716993044434L;

    /**
     * 账户 Id
     */
    private String mediaId;

    /**
     * 账户名称
     */
    private String mediaName;

    /**
     * 预付款·总额 ( 分 )
     */
    private Long prepaymentTotalMoney = 0L;

    /**
     * 预付款·杭州推啊 ( 分 )
     */
    @JsonProperty(value = "hzAdvancePayment")
    private Long hzPrepaymentMoney = 0L;

    /**
     * 预付款·霍尔果斯推啊 ( 分 )
     */
    @JsonProperty(value = "htAdvancePayment")
    private Long htPrepaymentMoney = 0L;

    /**
     * 预付款·霍城兑捷 ( 分 )
     */
    @JsonProperty(value = "djAdvancePayment")
    private Long hdPrepaymentMoney = 0L;

    /**
     * 预付款·兑推 ( 分 )
     */
    @JsonProperty(value = "duituiAdvancePayment")
    private Long duituiPrepaymentMoney = 0L;

    /**
     * 预付款消耗·总额 ( 分 )
     */
    private Long consumeTotalMoney = 0L;

    /**
     * 预付款消耗·杭州推啊 ( 分 )
     */
    @JsonProperty(value = "hzConsumption")
    private Long hzConsumeMoney = 0L;

    /**
     * 预付款消耗·霍尔果斯推啊 ( 分 )
     */
    @JsonProperty(value = "htConsumption")
    private Long htConsumeMoney = 0L;

    /**
     * 预付款消耗·霍城兑捷 ( 分 )
     */
    @JsonProperty(value = "djConsumption")
    private Long hdConsumeMoney = 0L;

    /**
     * 预付款消耗·兑推 ( 分 )
     */
    @JsonProperty(value = "duituiConsumption")
    private Long duituiConsumeMoney = 0L;

    /**
     * 已开票·总额 ( 分 )
     */
    private Long invoicedTotalMoney = 0L;

    /**
     * 已开票·杭州推啊 ( 分 )
     */
    @JsonProperty(value = "hzAfterInvoicePayment")
    private Long hzInvoicedMoney = 0L;

    /**
     * 已开票·霍尔果斯推啊 ( 分 )
     */
    @JsonProperty(value = "htAfterInvoicePayment")
    private Long htInvoicedMoney = 0L;

    /**
     * 已开票·霍城兑捷 ( 分 )
     */
    @JsonProperty(value = "djAfterInvoicePayment")
    private Long hdInvoicedMoney = 0L;

    /**
     * 已开票·兑推 ( 分 )
     */
    @JsonProperty(value = "duituiAfterInvoicePayment")
    private Long duituiInvoicedMoney = 0L;

    /**
     * 未开票·总额 ( 分 )
     */
    private Long notInvoicedTotalMoney = 0L;

    /**
     * 未开票·杭州推啊 ( 分 )
     */
    @JsonProperty(value = "hzOwedPayment")
    private Long hzNotInvoicedMoney = 0L;

    /**
     * 未开票·霍尔果斯推啊 ( 分 )
     */
    @JsonProperty(value = "htOwedPayment")
    private Long htNotInvoicedMoney = 0L;

    /**
     * 未开票·霍城兑捷 ( 分 )
     */
    @JsonProperty(value = "djOwedPayment")
    private Long hdNotInvoicedMoney = 0L;

    /**
     * 未开票·兑推 ( 分 )
     */
    @JsonProperty(value = "duituiOwedPayment")
    private Long duituiNotInvoicedMoney = 0L;


    public Long getPrepaymentTotalMoney() {
        prepaymentTotalMoney = Optional.ofNullable(hzPrepaymentMoney).orElse(0L) +
                Optional.ofNullable(htPrepaymentMoney).orElse(0L) +
                Optional.ofNullable(hdPrepaymentMoney).orElse(0L) +
                Optional.ofNullable(duituiPrepaymentMoney).orElse(0L);
        return prepaymentTotalMoney;
    }

    public Long getConsumeTotalMoney() {
        consumeTotalMoney = Optional.ofNullable(hzConsumeMoney).orElseGet(() -> Long.valueOf("0")) +
                Optional.ofNullable(htConsumeMoney).orElse(0L) +
                Optional.ofNullable(hdConsumeMoney).orElse(0L) +
                Optional.ofNullable(duituiConsumeMoney).orElse(0L);
        return consumeTotalMoney;
    }

    public Long getInvoicedTotalMoney() {
        invoicedTotalMoney = Optional.ofNullable(hzInvoicedMoney).orElse(0L) +
                Optional.ofNullable(htInvoicedMoney).orElse(0L) +
                Optional.ofNullable(hdInvoicedMoney).orElse(0L) +
                Optional.ofNullable(duituiInvoicedMoney).orElse(0L);
        return invoicedTotalMoney;
    }

    public Long getNotInvoicedTotalMoney() {
        notInvoicedTotalMoney = Optional.ofNullable(hzNotInvoicedMoney).orElse(0L) +
                Optional.ofNullable(htNotInvoicedMoney).orElse(0L) +
                Optional.ofNullable(hdNotInvoicedMoney).orElse(0L) +
                Optional.ofNullable(duituiNotInvoicedMoney).orElse(0L);
        return notInvoicedTotalMoney;
    }

    public InvoiceTrackingDto setHzNotInvoicedMoney(Long money) {
        this.hzNotInvoicedMoney = Objects.nonNull(money) && money >= 0L ? money : 0L;
        return this;
    }

    public InvoiceTrackingDto setHtNotInvoicedMoney(Long money) {
        this.htNotInvoicedMoney = Objects.nonNull(money) && money >= 0L ? money : 0L;
        return this;
    }

    public InvoiceTrackingDto setHdNotInvoicedMoney(Long money) {
        this.hdNotInvoicedMoney = Objects.nonNull(money) && money >= 0L ? money : 0L;
        return this;
    }

    public InvoiceTrackingDto setDtNotInvoicedMoney(Long money) {
        this.duituiNotInvoicedMoney = Objects.nonNull(money) && money >= 0L ? money : 0L;
        return this;
    }

    public static void main(String[] args) {
        System.out.println(RandomStringUtils.randomAlphanumeric(32));
        System.out.println(StringUtils.rightPad("a3", 4, "T"));
    }

}