/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.util;

import java.util.Date;

public class CostTimeShowUtils {
    private static final String DAY_SUFFIX = " \u5929 ";
    private static final String HOUR_SUFFIX = " \u5c0f\u65f6 ";
    private static final String MINUS_SUFFIX = " \u5206 ";
    private static final String SECONDS_SUFFIX = " \u79d2";

    public static String format(Date startTime, Date endTime) {
        long minus;
        long left;
        long hour;
        if (startTime == null || endTime == null || startTime.after(endTime)) {
            return null;
        }
        Long costTimeMills = endTime.getTime() - startTime.getTime();
        long day = costTimeMills / 86400000L;
        StringBuilder sb = new StringBuilder();
        if (day > 0L) {
            sb.append(day).append(DAY_SUFFIX);
        }
        if ((hour = (left = costTimeMills - 86400000L * day) / 3600000L) > 0L) {
            sb.append(hour).append(HOUR_SUFFIX);
        }
        if ((minus = (left -= 3600000L * hour) / 60000L) > 0L) {
            sb.append(minus).append(MINUS_SUFFIX);
        }
        sb.append((left -= 60000L * minus) / 1000L).append(SECONDS_SUFFIX);
        return sb.toString();
    }
}

