package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

/**
 * ActivityManualPlanDto
 */
@Data
public class ActivityManualPlanDto extends BaseDto {

    private static final long serialVersionUID = -5433858401741977928L;

    /** 未开始 */
    public static final int   STATUS_PREVIEW   = 0;

    /** 正在投放 */
    public static final int   STATUS_RELEASE   = 1;

    /** 已过期 */
    public static final int   STATUS_EXPIRED   = 2;

    /** 计划类型 0-活动 */
    public static final int   PLAN_TYPE_ACT    = 0;

    /** 计划类型 1-主会场 */
    public static final int   PLAN_TYPE_VENUE  = 1;

    private Long              activityId;

    private Integer           activityType;

    private String            activityName;

    private String            activityUrl;

    private Integer           activityStatus;

    private Long              operatorActivityId;

    private String            releaseTime;

    private Integer           status;

    private Long              slotId;

    private Integer           planType;

    /** 活动来源 0-兑吧 1-推啊 2-流量引导页 */
    private Integer           actSource;

    /** 手动投放 投放方式 0 轮询，1 定时 */
    private Integer           launchType;

    /** 测试广告位子投放方式: 仅投1 优投人工2 优投算法3 纯算法4 其他0 */
    private Integer           subActivityWay;

    /** 屏蔽活动状态 */
    private Integer           shieldActTagFlag;

    /** 活动皮肤类型 */
    private String            subType;

    /** 活动皮肤名称 */
    private String            skinName;

    /** 是否是海外活动 0正常 1海外 */
    private Integer           overseas;

    /**
     * 活动测试计划ID
     */
    private Long              planId;

    /**
     * 是否是测试活动类型
     */
    private Integer           isTestActivityType;

    /**
     * 广告位地域类型ID
     */
    private Long regionId;

    /**
     * 是否支持增值 0-否 1-是
     */
    private Integer isEnc;

    /**
     * 所属组
     */
    private Byte belongToGroup;

    /**
     * 定时投放活动 测试开关
     */
    private Byte actPlanStatus;

    private Boolean  notice = false;

    /** 屏蔽活动皮肤状态 1-被当前广告位屏蔽 */
    private Integer shieldActSkinTagFlag;

    /** 是否匹配行业标签 */
    private Integer             isMatchTradeTag;

    /** 活动行业标签列表 */
    private List<TagLibraryDto> activityTradeTagList;

    private String algoType;  //算法类型
    private Long testPlanId;  //测试计划id
    private Integer outputSource;  //活动投放来源：0非活动引擎，1活动引擎

    /**
     * 预警文案
     */
    private String prewarningContent;

    /**
     * 是否是程序化活动
     */
    private Boolean programmatic;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
