package cn.com.duiba.tuia.ssp.center.api.remote.ocpx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.OperatorMediaReportRspDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.OperatorMediaReportStrategyDto;
import cn.com.duiba.tuia.ssp.center.api.dto.OperatorMediaReportStrategyRspDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.OperatorMediaReportQuery;
import cn.com.duiba.tuia.ssp.center.api.params.OperatorMediaReportReq;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteOperatorMediaReportService {
    /**
     * 添加策略
     *
     * @param req
     * @return
     */
    Boolean addReportStrategy(OperatorMediaReportReq req);

    /**
     * 编辑策略
     *
     * @param req
     * @return
     */
    Boolean editReportStrategy(OperatorMediaReportReq req);


    /**
     * 查询策略列表
     *
     * @param param
     * @return
     */
    PageResultDto<OperatorMediaReportStrategyRspDto> listReportStrategy(OperatorMediaReportQuery param);

    List<OperatorMediaReportStrategyRspDto> queryByCondition(OperatorMediaReportQuery param);

    /**
     * 查询策略详情
     *
     * @param id
     * @return
     */
    OperatorMediaReportRspDTO queryReportStrategyDetail(Long id);

    /**
     * 通过积木id查询配置
     *
     * @param pageId 积木id
     * @return
     */
    OperatorMediaReportRspDTO queryDetailByPageId(String pageId);

    /**
     * 删除上报策略
     *
     * @param id 上报策略id
     * @return
     */
    Boolean delete(Long id);

    OperatorMediaReportStrategyDto getByPageId(String pageId);

    List<String> listPageId(OperatorMediaReportQuery param);

    Integer getTopSubtypeOfStrategyByPageId(String jimuId);
}
