package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2024/12/28
 * @Description
 **/
@Getter
public enum ProvinceAreaCodeEnum {
    BEIJIN("11", "北京市"),
    TIANJIN("12", "天津市"),
    HEBEI("13", "河北省"),
    SHANXI("14", "山西省"),
    NEIMENGGU("15", "内蒙古自治区"),
    LIAONING("21", "辽宁省"),
    JILIN("22", "吉林省"),
    HEILONGJIANG("23", "黑龙江省"),
    SHANGHAI("31", "上海市"),
    JIANGSU("32", "江苏省"),
    ZHEJIANG("33", "浙江省"),
    ANHUI("34", "安徽省"),
    FUJIAN("35", "福建省"),
    JIANGXI("36", "江西省"),
    SHANDONG("37", "山东省"),
    HENAN("41", "河南省"),
    HUBEI("42", "湖北省"),
    HUNAN("43", "湖南省"),
    GUANGDONG("44", "广东省"),
    GUANGXI("45", "广西壮族自治区"),
    HAINAN("46", "海南省"),
    CHONGQING("50", "重庆市"),
    SICHUAN("51", "四川省"),
    GUIZHOU("52", "贵州省"),
    YUNNAN("53", "云南省"),
    XIZANG("54", "西藏自治区"),
    SHAN_XI("61", "陕西省"),
    GANSU("62", "甘肃省"),
    QINGHAI("63", "青海省"),
    NIGNXIA("64", "宁夏回族自治区"),
    XINJIANG("65", "新疆维吾尔自治区"),
    TAIWAN("71", "台湾省"),
    HANGKONG("81", "香港"),
    AOMEN("82", "澳门"),;
    private String code;
    private String desc;

    ProvinceAreaCodeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code){
        for (ProvinceAreaCodeEnum provinceAreaCodeEnum : ProvinceAreaCodeEnum.values()) {
            if (provinceAreaCodeEnum.code.equals(code)){
                return provinceAreaCodeEnum.desc;
            }
        }
        return null;
    }
}
