package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/21
 * 策略ID 1-多O概率上报 2-单资源概率上报 3-直接上报
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum StrategyReportTypeEnum {
    /**
     * 多O概率上报
     */
    MULTIPLE_O_PROBABILITY_REPORT(1, "多O概率上报"),
    /**
     * 单资源概率上报
     */
    SINGLE_RESOURCE_PROBABILITY_REPORTING(2, "单资源概率上报"),
    /**
     * 直接上报
     */
    REPORT_DIRECTLY(3, "直接上报"),
    /**
     * 固定收益上报
     */
    FIXED_INCOME(4, "固定收益上报"),
    /**
     * 固定收益-自定义上报
     */
    FIXED_INCOME_CUSTOMIZE(5, "固定收益-自定义上报"),
    /**
     * 概率上报2.0（前端叫固定比例上报）
     */
    PROBABILITY_ACCURATE_REPORT(6, "多O概率上报2.0"),
    /**
     * 固定理论收益上报
     */
    THEORETICAL_INCOME_REPORT(7, "固定理论收益上报"),
    /**
     * 固定理论收益-自定义上报
     */
    THEORETICAL_INCOME_CUSTOM_REPORT(8, "固定理论收益-自定义上报"),
    /**
     * 固定收益-行业上报
     */
    FIXED_INCOME_INDUSTRY(9, "固定收益-行业上报"),
    /**
     * 固定收益-行业算法上报
     */
    FIXED_INCOME_INDUSTRY_ALG(10, "固定收益-行业算法上报"),
    /**
     * 高质量分上报(保险：蚂蚁支付分  贷款：授信额度)
     */
    HIGH_ANT_SCORE_REPORT(11, "高质量分上报"),
    /**
     * 高质量分上报(补量)(蚂蚁支付分)
     */
    HIGH_ANT_SCORE_REPORT_FIX(12, "高质量分上报(补量)"),

    PROVINCE_REPORT(13, "固定收益-省份上报"),
    PROVINCE_FIX_INCOME_REPORT(14, "省份固定收益"),

    DCVR_INCOME_REPORT(15, "固定收益-行业分层上报"),

    SIGN_REATE_INCOME_REPORT(16, "固定收益-货到签收分层上报"),

    /**
     * 高质量分上报(贷款：蚂蚁支付分)
     */
    ANT_HIGH_ANT_SCORE_REPORT(17, "高质量分上报（蚂蚁支付分）"),
    PROVINCE_CARRIER_FIX_INCOME_REPORT(18, "固定收益-省份网络运营商自定义上报"),
    PROVINCE_CARRIER_INCOME_REPORT(19, "固定收益-省份网络运营商上报"),


    HIGH_VERIFICATION_SIGN_REPORT(20, "固定收益-货到高核单高签收上报"),

    ;

    private Integer strategyId;

    private String desc;

    StrategyReportTypeEnum(Integer strategyId, String desc){
        this.strategyId = strategyId;
        this.desc = desc;
    }

    public static String getDescByStrategyId(Integer strategyId){
        for (StrategyReportTypeEnum strategyReportTypeEnum : StrategyReportTypeEnum. values()){
            if(strategyReportTypeEnum.getStrategyId().equals(strategyId)){
                return strategyReportTypeEnum.getDesc();
            }
        }
        return "";
    }
}
