package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.TencentMaterialAuditDto;
import cn.com.duiba.tuia.ssp.center.api.dto.TencentMaterialAuditListReq;

import java.util.List;
import java.util.Map;

/**
 * 腾讯素材送审服务
 */
@AdvancedFeignClient
public interface RemoteTencentMaterialAuditService {

    int countAuditList(TencentMaterialAuditListReq req);

    /**
     * 分页查询送审列表
     *
     * @param req
     * @return
     */
    List<TencentMaterialAuditDto> queryAuditList(TencentMaterialAuditListReq req);


    /**
     * 审核通过/拒绝
     *
     * @param materialId
     * @param status
     * @return
     */
    Boolean updateAuditStatus(Long materialId, Integer status);


    Boolean updateAuditStatusByOperator(Long id,Long materialId, Integer status, String operatorId, String operatorName);

    /**
     * 保存一条审核记录
     *
     * @param dto
     * @return
     */
    Boolean saveAuditRecord(TencentMaterialAuditDto dto);

    /**
     * 保存多条审核记录
     *
     * @return
     */
    Integer batchSaveAuditRecord(List<TencentMaterialAuditDto> dtos);

    /**
     * 查询一条审核记录
     *
     * @param materialId
     * @return
     */
    List<TencentMaterialAuditDto> selectAuditRecord(Long materialId);

    /**
     * 查询操作人列表
     *
     * @return
     */
    List<Map<String, String>> selectOperatorList();

    /**
     * 查询通过审核的素材id列表
     *
     * @return
     */
    List<Long> selectPassMaterialIds();

    /**
     * 查询通过审核的配置id列表
     *
     * @return
     */
    List<Long> selectPassOrientationIds();


    List<String> selectPassMaterialAndOrientation();

    /**
     * 当送审后的配置链接发生变化时，所有素材自动重新送审
     *
     * @param landId
     * @param landUrl
     * @return
     */
    Boolean autoAuditByLandChange(Long landId, String landUrl);

    Boolean autoAuditByPackageChange(Long packageId, String landUrl, Long landId);


    Boolean autoAuditByAdvertChange(Long advertId, String landUrl);

    Boolean autoAuditByMaterialsChange(List<Long> materialIds, String landUrl);

    /**
     * 多条件查询
     * @param tencentMaterialAuditListReq
     * @return
     */
    List<TencentMaterialAuditDto> queryByConditions(TencentMaterialAuditListReq tencentMaterialAuditListReq);

    TencentMaterialAuditDto queryByPrimaryId(Long id);


}
