package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 行业清单
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class IndustryListing implements Serializable {

    /**
     * 类别 Id
     */
    private String sortId;

    /**
     * 类别名称
     */
    private String sortName;

    /**
     * 媒体总计
     */
    private String total;

    /**
     * 已对接 · 有消耗计数
     */
    private String haveConsume;

    /**
     * 已对接 · 有消耗状态值
     */
    private String haveConsumeStatus;

    /**
     * 已对接 · 无消耗计数
     */
    private String noConsume;

    /**
     * 已对接 · 无消耗状态值
     */
    private String noConsumeStatus;

    /**
     * 未对接计数
     */
    private String noDocking;

    /**
     * 未对接状态值
     */
    private String noDockingStatus;

}
