package cn.com.duiba.tuia.ssp.center.api.dto.media;

import lombok.Data;

import java.io.Serializable;

/**
 * @author Jason
 * @since 2021-09-13 10:24 AM
 */
@Data
public class AdvertWhiteRequest implements Serializable {

    private static final long serialVersionUID = 1389621593031075335L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 广告计划ID
     */
    private Long advertId;

    /**
     * 广告行业
     */
    private String advertIndustry;

    /**
     * 状态（0:关闭 1:打开）
     */
    private Integer advertStatus;

    /**
     * 投放开始时间
     */
    private String startDate;

    /**
     * 投放结束时间
     */
    private String endDate;

    /**
     * 投放时间段
     */
    private String timePeriod;

    /**
     * 定向地域
     */
    private String regionIds;

    /**
     * 发券次序
     */
    private String requestTimes;

    /**
     * 出价（单位：元）
     */
    private String price;

    /**
     * 当前页
     */
    private Integer currentPage;

    /**
     * 页面数量
     */
    private Integer pageSize;
}
