package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.List;
@Data
@ApiModel
public class UnionAppDailyProfitReq extends BaseQueryDto {

    private static final long serialVersionUID = 3831443832799643264L;


    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    @ApiModelProperty(value = "endDate", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    @ApiModelProperty(value = "运营名称", required = false)
    private String            operatorName;

    @ApiModelProperty(value = "媒体id ", required = false)
    private String            appIds;

    @ApiModelProperty(value = "消耗小于", required = false)
    private Long              minConsume;

    @ApiModelProperty(value = "消耗大于", required = false)
    private Long              maxConsume;

    @ApiModelProperty(value = "状态：0-未确定，1-确定", required = false)
    private Integer           dataType;

    @ApiModelProperty(value = "查询的运营id（权限） ", required = false)
    private List<Long>            operatorIds;

    @ApiModelProperty(value = "媒体id ", required = false)
    private List<Long>            appIdsLong;

}
