package cn.com.duiba.tuia.ssp.center.api.remote.task;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;

/**
 * 临时用，针对结算方式为分成、UV单价、PV单价，并且有流量调整的，重新同步下广告位日数据的原广告消耗、原现金消耗等
 *
 * @author zhongda & ikongyi
 */
@AdvancedFeignClient
public interface RemoteSlotDailyStatisticsOriginalAmountSyncTaskService {

    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="30000")
    Result<Integer> execute(String request) throws BizException;

}
