package cn.com.duiba.tuia.ssp.center.api.dto.dmp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangzichen
 */
@Data
@ApiModel("数据源管理返回对象")
public class ThirdPartyDmpDTO implements Serializable {

    private static final long serialVersionUID = 5761571817292589365L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("数据源名称")
    private String dmpName;

    @ApiModelProperty("数据对接方式")
    private String dataSourceType;

    @ApiModelProperty("数据更新机制枚举值")
    private Integer dataUpdateFre;

    @ApiModelProperty("开关状态")
    private Integer enableState;

    @ApiModelProperty("媒体定向状态")
    private Integer appState;
    @ApiModelProperty("数据源Key")
    private String dmpKey;
    @ApiModelProperty("切流比例，取值范围：0-100，默认100，表示不对流量做限制")
    private Integer flowRate;
    @ApiModelProperty("自定义更新机制输入的时间，xx分钟")
    private Long dataUpdateTime;
    @ApiModelProperty("qps限流，xx次")
    private Long qpsNum;
    private Long expireTime;

    @ApiModelProperty("标签时效，单位s")
    private Long tagPrescription;

    @ApiModelProperty("标签时效单位-给前端用")
    private Integer prescriptionUnit;

    @ApiModelProperty("是否支持批量请求 1 ： 支持批量请求，0 不支持批量请求")
    private Integer  ifBatch ;


}
