package cn.com.duiba.tuia.ssp.center.api.params.dmp;


import cn.com.duiba.tuia.ssp.center.api.dto.dmp.CalcConditionRuleDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.CustomRuleDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.DetailDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.DimensionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.LabelDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.UserBehaviorDto;
import cn.com.duiba.tuia.ssp.center.api.dto.dmp.UserCodeRuleDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class CrowdParms extends PageParams implements java.io.Serializable {
    private static final long serialVersionUID = -5658941630970355752L;
    @ApiModelProperty("人群包ID")
    private Long id;
    @ApiModelProperty("人群包ID")
    private Long crowdId;

    @ApiModelProperty("人群包详情表ID")
    private Long crowdDetailId;
    @ApiModelProperty("人群包名称")
    private String crowdName;
    @ApiModelProperty("人群包类型: 1私有人群包，2行业人群包")
    private Integer crowdType;
    @ApiModelProperty("创建方式：新建1，上传2，第三方厂家3，接口触发4")
    private Integer createType;
    @ApiModelProperty("创建人Id")
    private Long adminId;
    @ApiModelProperty("数据类型：IMEIMD5 --> 1，IMEI--> 2 ,IDFA--> 3,IDFAMD5--> 4,IDFA 5,IDFA-MD5 6")
    private Integer dataType;
    @ApiModelProperty("人群包创建时间")
    private String createTime;
    @ApiModelProperty("人群包有效状态: 计算中 1，计算完成 2，失败 3，更新中 4，更新完成 5，可查询 6")
    private Integer validState;
    @ApiModelProperty("新建人群包配置详情")
    private DetailDto detailDtos;
    @ApiModelProperty("人群包ID上传方式创建的人群包数据条数")
    private String upLoadCount;
    @ApiModelProperty("更新机制: 不更新1，自动更新2")
    private Integer updateStrategy = 0;
    @ApiModelProperty("上传文件的url列表")
    private List<String> deviceInfos;
    @ApiModelProperty("基于类型: 基于广告1，基于用户2")
    private Integer baseType;
    @ApiModelProperty("开始时间")
    private String startTime;
    @ApiModelProperty("结束时间")
    private String endTime;
    @ApiModelProperty("推送状态：0 未推送，1 推送成功")
    private Integer isPush;
    @ApiModelProperty("是否自动推送:0 不推送，1 自动推送")
    private Integer isAutoPush;
    @ApiModelProperty("是否广告主创建：0 否，1是")
    private Integer isAccount;
    @ApiModelProperty("人群包类型列表:由于产品将原两种类型混合为一种类型，所以此处特殊处理")
    private List<Integer> crowdTypes;

    /**
     * 基于广告的人群包信息
     */
    @ApiModelProperty("数据源时间 (天)")
    private Integer dataSourceTime;
    @ApiModelProperty("基于广告 的维度配置详情")
    private DimensionDto dimensionDtos;
    @ApiModelProperty("基于广告 的用户行为配置详情")
    private UserBehaviorDto userBehaviorDtos;


    /**
     * 基于用户特征配置详情
     *
     * @return
     */
    @ApiModelProperty("性别: 1不限，2男，3女")
    private String gender;
    @ApiModelProperty("'年龄段'")
    private List<String> ageRange;
    @ApiModelProperty("''应用类别- 应用兴趣")
    private List<LabelDto> appInterests;
    @ApiModelProperty("游戏兴趣")
    private List<LabelDto> gameInterest;
    @ApiModelProperty("消费偏好")
    private List<LabelDto> consumerPrefer;
    @ApiModelProperty("婚育情况")
    private List<LabelDto> maritalStatus;
    @ApiModelProperty("身份职业")
    private List<LabelDto> occupation;
    @ApiModelProperty("自定义规则列表")
    private List<CustomRuleDto> customRules;

    @ApiModelProperty("包含项信息")
    private List<UserCodeRuleDto> userCodeRuleDtosWith;
    @ApiModelProperty("排除项信息")
    private List<UserCodeRuleDto> userCodeRuleDtosNot;

    @ApiModelProperty("运算池条件类型(变量命名跟随前端命名)")
    private List<CalcConditionRuleDto> operationList;
    @ApiModelProperty("运算池String类型")
    private String operationStr;
    @ApiModelProperty("人群包Id集合")
    private List<Long> ids;

    private Integer pageCurrent;
    /**
     * 1-adx点击
     */
    private Integer metric;
    /**
     * 1-adx点击
     */
    private Integer dimension;
    /**
     * 维度值，多个逗号分隔
     */
    private String value;
    /**
     * 开始日期(日期格式：yyyy-MM-dd)
     */
    private String startDate;
    /**
     * 结束日期(日期格式：yyyy-MM-dd)
     */
    private String endDate;
    /**
     * 整数（1-180）
     */
    private String latestDay;


}
