package cn.com.duiba.tuia.ssp.center.api.params.dmp;


import cn.com.duiba.tuia.ssp.center.api.dto.dmp.KeyValueDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class DmpUserLabelRegulationParam {
    @ApiModelProperty("主键Id")
    private Long              id;
    @ApiModelProperty("标签Code")
    private String            currentCode;
    @ApiModelProperty("更新方式 1手动更新，2例行更新")
    private Integer           updateRegulation;
    @ApiModelProperty("创建方式 1规则清洗，2用户广告行为，3用户app安装行为")
    private Integer           createRegulation;
    @ApiModelProperty("时间维度 90天，30天，14天，7天")
    private Integer timeDimension;
    @ApiModelProperty("维度 1广告主 2广告计划 3广告行业")
    private Integer           dimension;
    @ApiModelProperty("维度Ids json格式")
    private List<KeyValueDto> dimensionIds;
    @ApiModelProperty("用户行为: 1曝光无点击，2点击，3点击无转化，4落地页转化，5启动app，6注册app，7付费，8完件，9留存")
    private List<Integer>     userBehavior;
    @ApiModelProperty("用户安装app: 1等于，2包含")
    private Integer userInstall;
    @ApiModelProperty("用户安装app规则值")
    private List<String> userInstallRegulation;
}
