package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

/**
 * @author fangzhipeng
 * @date 2018/8/17
 */
public class SlotMsInfoDto implements Serializable {

    private static final long serialVersionUID = -3394314154754486862L;
    /**
     * 广告位Id
     */
    private Long slotId;

    /**
     * 广告位宽度
     */
    private Integer width;

    /**
     * 广告位高度
     */
    private Integer height;

    /** 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙. */
    private Integer slotType;

    //投放场景 1:'插屏',2:'banner/横幅',3:'信息流',6:'浮标',7:'应用墙',8:'开屏',9:'自定义场景',10:'原生插屏'
    private Integer sceneType;

    public SlotMsInfoDto() {}

    public SlotMsInfoDto(Long slotId, String width, String height, Integer slotType, Integer sceneType) {
        this.slotId = slotId;
        this.width = Integer.valueOf(width);
        this.height = Integer.valueOf(height);
        this.slotType = slotType;
        this.sceneType = sceneType;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public Integer getSceneType() {
        return sceneType;
    }

    public void setSceneType(Integer sceneType) {
        this.sceneType = sceneType;
    }
}
