/**
 * Project Name:media-manager-biz File Name:ReqActivityStatisticsByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月21日上午11:44:59 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqActAppStatDataByPage <br/>
 * Function: 活动下媒体数据统计. <br/>
 * Date: 2016年12月21日 上午11:44:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActAppStatDataByPage extends ReqPageQuery implements Serializable {

    /** 序列号. */
    private static final long serialVersionUID = -1158637634156561218L;

    /** 开始日期. */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期. */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    /** 活动ID. */
    @ApiModelProperty(value = "活动ID", required = true)
    @NotNull(message = "活动ID不能为空")
    private Long              activityId;

    /** 媒体ID. */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    /** The activity name. */
    @ApiModelProperty(value = "活动名称(用作导出)", required = false)
    private String            activityName;

    @ApiModelProperty(value = "媒体Id列表", required = false)
    private List<Long>        appIds;
    
    /**0-兑吧活动 1-推啊活动 2-流量引导页*/
    @ApiModelProperty(value = "活动来源", required = false)
    private Integer   source;
    
    /** 导出方式. */
    @ApiModelProperty(value = "导出方式", required = false)
    private Integer     exportType;//0是汇总，1是分日导出

    public Integer getExportType() {
		return exportType;
	}

	public void setExportType(Integer exportType) {
		this.exportType = exportType;
	}
    /**
     * appIds.
     *
     * @return the appIds
     * @since JDK 1.6
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * appIds.
     *
     * @param appIds the appIds to set
     * @since JDK 1.6
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the activity name.
     *
     * @return the activity name
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * Sets the activity name.
     *
     * @param activityName the activity name
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
