package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/5/29.
 */
@Getter
public enum BusinessTypeEnum {

    OPERATOR(0, "operator", "运营商"),
    HUIJICARD(1, "huiji", "会籍卡"),
    DAYOU(2, "dayou", "大有瑞吉"),
    WITHHOLD(3, "withhold", "代扣"),;
    private final Integer code;
    private final String  type;
    private final String  desc;

    BusinessTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static BusinessTypeEnum getByCode(Integer code) {
        return Stream.of(BusinessTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(OPERATOR);
    }

    public static BusinessTypeEnum getByType(String type) {
        return Stream.of(BusinessTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(OPERATOR);
    }
}
