package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2024/3/14.
 */
@Getter
public enum ChannelEnum {
    TUIA(1, "TUIA", "推啊"),
    PROGRAM(2, "PROGRAM", "程序化"),;
    private final Integer code;
    private final String type;
    private final String desc;

    ChannelEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ChannelEnum getByCode(Integer code) {
        return Stream.of(ChannelEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(TUIA);
    }

    public static ChannelEnum getByType(String type) {
        return Stream.of(ChannelEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(TUIA);
    }
}
