package cn.com.duiba.tuia.subscribe.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 积分明细状态枚举
 */
@Getter
public enum PointsDetailStatusEnum {

    VALID(1, "有效"),
    USED_UP(2, "已用完"),
    EXPIRED(3, "已过期"),
    REFUND_CLEARED(4, "已退款清空"),
    ;

    private final Integer code;
    private final String desc;

    PointsDetailStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PointsDetailStatusEnum getByCode(Integer code) {
        return Stream.of(PointsDetailStatusEnum.values())
                .filter(e -> e.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
