package cn.com.duiba.tuia.youtui.center.api.remoteservice;

/**
 * author: 胡 朋
 * github: https://github.com/xiaomoinfo
 * email : xiaomo@xiaomo.info
 * QQ    : 83387856
 * Date  : 2018/7/10 11:38
 * desc  :
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.CashOrderAuditReq;
import cn.com.duiba.tuia.youtui.center.api.dto.req.CashOrderReq;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiCashOrderDto;

import java.util.List;

/**
 * 提现相关服务
 * Created by xuefeng on 2018/6/11.
 */
@AdvancedFeignClient
public interface RemoteCashOrderService {

    /**
     * 获取提现列表信息
     * @param cashOrderReq
     * @param offset
     * @param max
     * @return
     */
    PageDto<YoutuiCashOrderDto> getList(CashOrderReq cashOrderReq, Integer offset, Integer max);

    /**
     * 审批
     * @param cashOrderAuditReq
     * @return
     */
    Boolean audit(CashOrderAuditReq cashOrderAuditReq);

    /**
     * 根据订单id查询
     * @param orderId
     * @return
     */
    YoutuiCashOrderDto getByOrderId(String orderId);

    /**
     *根据订单ids查询
     * @param orderIds
     * @return
     */
    List<YoutuiCashOrderDto> getByOrderIds(List<String> orderIds);
}
