package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.common.PageDto;
import cn.com.duiba.tuia.youtui.center.api.dto.req.YoutuiCyapQuery;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.*;

import java.util.List;

/**
 * 推广计划
 * Created by xuefeng on 2018/5/19.
 */
@AdvancedFeignClient
public interface RemoteYoutuiCyapService {

    /**
     * 根据内容id获取推广计划
     *
     * @param contentReq
     * @return
     */
    YoutuiCyapDto selectByContent(YoutuiContentReq contentReq);

    /**
     * 获取开启的推广计划
     *
     * @return
     */
    List<YoutuiCyapDto> selectPublishList();


    /**
     * 查询活动列表
     * @param youtuiCyapQuery 查询参数
     * @return 带分页的结果
     */
    PageDto<YoutuiCyapDto> getActivityList(YoutuiCyapQuery youtuiCyapQuery);


    /**
     * 置顶活动
     * @param id 活动id
     * @return 1成功 0为失败
     */
    int stickActivity(long id);


    /**
     * 活动取消置顶
     * @param id 活动id
     * @return 1成功 0为失败
     */
    int cancelStickActivity(long id);


    /**
     * 批量插入新活动
     * @param dtos 活动dto列表
     * @return
     */
    int insertActivityList(List<YoutuiActivityDto> dtos);


    /**
     * 删除一个活动
     * @param id 活动id
     * @return 是否删除成功  1删除成功 0删除失败
     */
    int deleteAnActivity(long id);

    /**
     * 修改上架内容
     * @param dto
     * @return
     */
    int updateCyap(YoutuiCyapDto dto);

    YoutuiCyapDto selectByActivityId(long id);

    /**
     * 通过content_id 和content_type
     * @param contentId
     * @param contentType
     * @return
     */
    YoutuiCyapDto selectByCidAndCtype(Long contentId,Integer contentType);
    /**
     * 添加直投页
     * @param dtos
     * @return
     */
    int insertGuidePageList(List<YoutuiGuidePageDto> dtos);

    int insertContextList(List<YoutuiContextDto> dtos);
}
