/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.youtui.center.api.constant;

/**
 * 描述: 提现金额枚举，单位：分
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/1/22 11:46
 */
public enum WithdrawAmountType {

    AMOUNT_ERROR(0, 0, 0),
    AMOUNT_50_FEE_5(5000, 4500, 500),
    AMOUNT_100_FEE_2(10000, 9800, 200),
    AMOUNT_200_FEE_0(20000, 20000, 0);

    private Integer consumption;

    private Integer amount;

    private Integer fee;

    WithdrawAmountType(Integer consumption, Integer amount, Integer fee) {
        this.consumption = consumption;
        this.amount = amount;
        this.fee = fee;
    }

    public Integer getConsumption() {
        return consumption;
    }

    public Integer getAmount() {
        return amount;
    }

    public Integer getFee() {
        return fee;
    }

    public static WithdrawAmountType getByConsumption(Integer consumption) {
        for (WithdrawAmountType e : WithdrawAmountType.values()) {
            if (e.getConsumption().equals(consumption)) {
                return e;
            }
        }
        return AMOUNT_ERROR;
    }

    public static WithdrawAmountType getByAmount(Integer amount) {
        for (WithdrawAmountType e : WithdrawAmountType.values()) {
            if (e.getAmount().equals(amount)) {
                return e;
            }
        }
        return AMOUNT_ERROR;
    }
}
