package cn.com.duiba.tuia.youtui.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiPutConfigDto;

/**
 * 内容投放配置
 *
 * @author songjiaxing
 */
@AdvancedFeignClient
public interface RemoteYoutuiPutConfigService {

    /**
     * 添加内容投放配置
     * @param youtuiPutConfigDto @see cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiPutConfigDto
     * @return
     */
    public Boolean addPutConfig(YoutuiPutConfigDto youtuiPutConfigDto);

    /**
     * 更新内容投放配置
     * @param youtuiPutConfigDto @see cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiPutConfigDto
     * @return
     */
    public Boolean updatePutConfig(YoutuiPutConfigDto youtuiPutConfigDto);

    /**
     * 查询内容投放配置
     * @param contentId 内容ID
     * @param contentType 内容类型
     * @return @see cn.com.duiba.tuia.youtui.center.api.dto.youtui.YoutuiPutConfigDto
     */
    public YoutuiPutConfigDto findYoutuiPutConfigByCidAndCtype(Long contentId, Integer contentType);
}
