package cn.com.duiba.tuia.youtui.center.api.constant.youtui;

import java.util.Objects;

/**
 * 任务分组
 * @author lichao 2018/7/4
 */
public enum MissionGroupType {
    NEWONE(0,"新手任务","http://yun.tuisnake.com/lx/mission/ngift.png","http://yun.tuia.cn/lx/mission/xinrenlibao.png"),//新手任务
    TIMING(1,"天天赚钱","https://yun.dui88.com/lx/mission/center.png","http://yun.tuia.cn/lx/mission/tanchaung.png")//日常任务

    ;

    private Integer code;

    private String name;

    private String icon;

    private String notifyImage;

    MissionGroupType(Integer code, String name, String icon, String notifyImage) {
        this.code = code;
        this.name = name;
        this.icon = icon;
        this.notifyImage = notifyImage;
    }

    public static MissionGroupType getByCode(Integer code){
        for (MissionGroupType type : MissionGroupType.values()){
            if(Objects.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getNotifyImage() {
        return notifyImage;
    }

    public void setNotifyImage(String notifyImage) {
        this.notifyImage = notifyImage;
    }
}
