package cn.com.duiba.tuia.youtui.center.api.dto.youtui;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 趣晒内容投放配置Dto
 */
@ApiModel("投放配置")
public class YoutuiPutConfigDto implements Serializable {

    @ApiModelProperty(value = "投放配置ID", dataType = "Long")
    private Long id;

    /**
     * 内容ID
     */
    @ApiModelProperty(value = "投放内容ID", dataType = "Long")
    private Long contentId;

    /**
     * 内容类型
     */
    @ApiModelProperty(value = "投放内容类型(1:活动；2:直投页；3:任务；4:游戏)", dataType = "Integer")
    private Integer contentType;

    /**
     * 内容投放格式配置
     */
    @ApiModelProperty(value = "投放内容格式配置", dataType = "ContentPutConfig")
    private ContentPutConfig cpConfig;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getContentId() {
        return contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public Integer getContentType() {
        return contentType;
    }

    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    public ContentPutConfig getCpConfig() {
        return cpConfig;
    }

    public void setCpConfig(ContentPutConfig cpConfig) {
        this.cpConfig = cpConfig;
    }

    /**
     * 内容投放格式配置
     */
    @ApiModel("投放内容格式配置")
    public static class ContentPutConfig {

        @ApiModelProperty(value = "平均收益基准值", dataType = "Long")
        private Long avgIncome;
        /**
         * app客户端投放配置
         */
        @ApiModelProperty(value = "客户端内展示配置", dataType = "List<AppClientPutConfigDto>")
        private List<AppClientPutConfigDto> acpcDtos;

        /**
         * 微信一级分享配置
         */
        @ApiModelProperty(value = "微信一级分享展示配置", dataType = "List<WechatPutConfigDto>")
        private List<WechatPutConfigDto> wcpcFirstDtos;

        /**
         * 开关状态(默认开启)
         */
        @ApiModelProperty(value = "微信次级分享配置开关状态(默认开启),0:未开启；1:开启", dataType = "Integer")
        private Integer openStatus;

        /**
         * 微信次级分享配置
         */
        @ApiModelProperty(value = "微信次级分享配置", dataType = "List<WechatPutConfigDto>")
        private List<WechatPutConfigDto> wcpcNextDtos;

        public Integer getOpenStatus() {
            return openStatus;
        }

        public void setOpenStatus(Integer openStatus) {
            this.openStatus = openStatus;
        }

        public Long getAvgIncome() {
            return avgIncome;
        }

        public void setAvgIncome(Long avgIncome) {
            this.avgIncome = avgIncome;
        }

        public List<AppClientPutConfigDto> getAcpcDtos() {
            return acpcDtos;
        }

        public void setAcpcDtos(List<AppClientPutConfigDto> acpcDtos) {
            this.acpcDtos = acpcDtos;
        }

        public List<WechatPutConfigDto> getWcpcFirstDtos() {
            return wcpcFirstDtos;
        }

        public void setWcpcFirstDtos(List<WechatPutConfigDto> wcpcFirstDtos) {
            this.wcpcFirstDtos = wcpcFirstDtos;
        }

        public List<WechatPutConfigDto> getWcpcNextDtos() {
            return wcpcNextDtos;
        }

        public void setWcpcNextDtos(List<WechatPutConfigDto> wcpcNextDtos) {
            this.wcpcNextDtos = wcpcNextDtos;
        }
    }
}
